/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.core.Registry;
import net.minecraft.util.MathHelper;
import org.jspecify.annotations.Nullable;

public class RegistryID<K>
implements Registry<K> {
    private static final int NOT_FOUND = -1;
    private static final Object EMPTY_SLOT = null;
    private static final float LOADFACTOR = 0.8f;
    private @Nullable K[] keys;
    private int[] values;
    private @Nullable K[] byId;
    private int nextId;
    private int size;

    private RegistryID(int var0) {
        this.keys = new Object[var0];
        this.values = new int[var0];
        this.byId = new Object[var0];
    }

    private RegistryID(K[] var0, int[] var1, K[] var2, int var3, int var4) {
        this.keys = var0;
        this.values = var1;
        this.byId = var2;
        this.nextId = var3;
        this.size = var4;
    }

    public static <A> RegistryID<A> create(int var0) {
        return new RegistryID((int)((float)var0 / 0.8f));
    }

    @Override
    public int getId(@Nullable K var0) {
        return this.getValue(this.indexOf(var0, this.hash(var0)));
    }

    @Override
    public @Nullable K byId(int var0) {
        if (var0 < 0 || var0 >= this.byId.length) {
            return null;
        }
        return this.byId[var0];
    }

    private int getValue(int var0) {
        if (var0 == -1) {
            return -1;
        }
        return this.values[var0];
    }

    public boolean contains(K var0) {
        return this.getId(var0) != -1;
    }

    public boolean contains(int var0) {
        return this.byId(var0) != null;
    }

    public int add(K var0) {
        int var1 = this.nextId();
        this.addMapping(var0, var1);
        return var1;
    }

    private int nextId() {
        while (this.nextId < this.byId.length && this.byId[this.nextId] != null) {
            ++this.nextId;
        }
        return this.nextId;
    }

    private void grow(int var0) {
        K[] var1 = this.keys;
        int[] var2 = this.values;
        RegistryID<K> var3 = new RegistryID<K>(var0);
        for (int var4 = 0; var4 < var1.length; ++var4) {
            if (var1[var4] == null) continue;
            var3.addMapping(var1[var4], var2[var4]);
        }
        this.keys = var3.keys;
        this.values = var3.values;
        this.byId = var3.byId;
        this.nextId = var3.nextId;
        this.size = var3.size;
    }

    public void addMapping(K var0, int var1) {
        int var3;
        int var2 = Math.max(var1, this.size + 1);
        if ((float)var2 >= (float)this.keys.length * 0.8f) {
            for (var3 = this.keys.length << 1; var3 < var1; var3 <<= 1) {
            }
            this.grow(var3);
        }
        var3 = this.findEmpty(this.hash(var0));
        this.keys[var3] = var0;
        this.values[var3] = var1;
        this.byId[var1] = var0;
        ++this.size;
        if (var1 == this.nextId) {
            ++this.nextId;
        }
    }

    private int hash(@Nullable K var0) {
        return (MathHelper.murmurHash3Mixer(System.identityHashCode(var0)) & Integer.MAX_VALUE) % this.keys.length;
    }

    private int indexOf(@Nullable K var0, int var1) {
        int var2;
        for (var2 = var1; var2 < this.keys.length; ++var2) {
            if (this.keys[var2] == var0) {
                return var2;
            }
            if (this.keys[var2] != EMPTY_SLOT) continue;
            return -1;
        }
        for (var2 = 0; var2 < var1; ++var2) {
            if (this.keys[var2] == var0) {
                return var2;
            }
            if (this.keys[var2] != EMPTY_SLOT) continue;
            return -1;
        }
        return -1;
    }

    private int findEmpty(int var0) {
        int var1;
        for (var1 = var0; var1 < this.keys.length; ++var1) {
            if (this.keys[var1] != EMPTY_SLOT) continue;
            return var1;
        }
        for (var1 = 0; var1 < var0; ++var1) {
            if (this.keys[var1] != EMPTY_SLOT) continue;
            return var1;
        }
        throw new RuntimeException("Overflowed :(");
    }

    @Override
    public Iterator<K> iterator() {
        return Iterators.filter((Iterator)Iterators.forArray((Object[])this.byId), (Predicate)Predicates.notNull());
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.byId, null);
        this.nextId = 0;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public RegistryID<K> copy() {
        return new RegistryID<Object>((Object[])this.keys.clone(), (int[])this.values.clone(), (Object[])this.byId.clone(), this.nextId, this.size);
    }
}

