/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.util.SystemUtils;

public class EntitySlice<T>
extends AbstractCollection<T> {
    private final Map<Class<?>, List<T>> byClass = Maps.newHashMap();
    private final Class<T> baseClass;
    private final List<T> allInstances = Lists.newArrayList();

    public EntitySlice(Class<T> var0) {
        this.baseClass = var0;
        this.byClass.put(var0, this.allInstances);
    }

    @Override
    public boolean add(T var0) {
        boolean var1 = false;
        for (Map.Entry<Class<?>, List<T>> var3 : this.byClass.entrySet()) {
            if (!var3.getKey().isInstance(var0)) continue;
            var1 |= var3.getValue().add(var0);
        }
        return var1;
    }

    @Override
    public boolean remove(Object var0) {
        boolean var1 = false;
        for (Map.Entry<Class<?>, List<T>> var3 : this.byClass.entrySet()) {
            if (!var3.getKey().isInstance(var0)) continue;
            List<T> var4 = var3.getValue();
            var1 |= var4.remove(var0);
        }
        return var1;
    }

    @Override
    public boolean contains(Object var0) {
        return this.find(var0.getClass()).contains(var0);
    }

    public <S> Collection<S> find(Class<S> var02) {
        if (!this.baseClass.isAssignableFrom(var02)) {
            throw new IllegalArgumentException("Don't know how to search for " + String.valueOf(var02));
        }
        List var1 = this.byClass.computeIfAbsent(var02, var0 -> this.allInstances.stream().filter(var0::isInstance).collect(SystemUtils.toMutableList()));
        return Collections.unmodifiableCollection(var1);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.allInstances.isEmpty()) {
            return Collections.emptyIterator();
        }
        return Iterators.unmodifiableIterator(this.allInstances.iterator());
    }

    public List<T> getAllInstances() {
        return ImmutableList.copyOf(this.allInstances);
    }

    @Override
    public int size() {
        return this.allInstances.size();
    }
}

