/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagKey;

public class TagNetworkSerialization {
    public static Map<ResourceKey<? extends IRegistry<?>>, a> serializeTagsToNetwork(LayeredRegistryAccess<RegistryLayer> var02) {
        return RegistrySynchronization.networkSafeRegistries(var02).map(var0 -> Pair.of(var0.key(), (Object)TagNetworkSerialization.serializeToNetwork(var0.value()))).filter(var0 -> !((a)var0.getSecond()).isEmpty()).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private static <T> a serializeToNetwork(IRegistry<T> var0) {
        HashMap<MinecraftKey, IntList> var1 = new HashMap<MinecraftKey, IntList>();
        var0.getTags().forEach(var2 -> {
            IntArrayList var3 = new IntArrayList(var2.size());
            for (Holder var5 : var2) {
                if (var5.kind() != Holder.b.REFERENCE) {
                    throw new IllegalStateException("Can't serialize unregistered value " + String.valueOf(var5));
                }
                var3.add(var0.getId(var5.value()));
            }
            var1.put(var2.key().location(), (IntList)var3);
        });
        return new a(var1);
    }

    static <T> TagDataPack.c<T> deserializeTagsFromNetwork(IRegistry<T> var0, a var1) {
        ResourceKey var2 = var0.key();
        HashMap var32 = new HashMap();
        var1.tags.forEach((var3, var4) -> {
            TagKey var5 = TagKey.create(var2, var3);
            List var6 = var4.intStream().mapToObj(var0::get).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
            var32.put(var5, var6);
        });
        return new TagDataPack.c<T>(var2, var32);
    }

    public static final class a {
        public static final a EMPTY = new a(Map.of());
        final Map<MinecraftKey, IntList> tags;

        a(Map<MinecraftKey, IntList> var0) {
            this.tags = var0;
        }

        public void write(PacketDataSerializer var0) {
            var0.writeMap(this.tags, PacketDataSerializer::writeIdentifier, PacketDataSerializer::writeIntIdList);
        }

        public static a read(PacketDataSerializer var0) {
            return new a(var0.readMap(PacketDataSerializer::readIdentifier, PacketDataSerializer::readIntIdList));
        }

        public boolean isEmpty() {
            return this.tags.isEmpty();
        }

        public int size() {
            return this.tags.size();
        }

        public <T> TagDataPack.c<T> resolve(IRegistry<T> var0) {
            return TagNetworkSerialization.deserializeTagsFromNetwork(var0, this);
        }
    }
}

