/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.Objects;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.JsonList;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.WhiteListEntry;

public class WhiteList
extends JsonList<NameAndId, WhiteListEntry> {
    public WhiteList(File var0, NotificationService var1) {
        super(var0, var1);
    }

    @Override
    protected JsonListEntry<NameAndId> createEntry(JsonObject var0) {
        return new WhiteListEntry(var0);
    }

    public boolean isWhiteListed(NameAndId var0) {
        return this.contains(var0);
    }

    @Override
    public boolean add(WhiteListEntry var0) {
        if (super.add(var0)) {
            if (var0.getUser() != null) {
                this.notificationService.playerAddedToAllowlist((NameAndId)var0.getUser());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(NameAndId var0) {
        if (super.remove(var0)) {
            this.notificationService.playerRemovedFromAllowlist(var0);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (WhiteListEntry var1 : this.getEntries()) {
            if (var1.getUser() == null) continue;
            this.notificationService.playerRemovedFromAllowlist((NameAndId)var1.getUser());
        }
        super.clear();
    }

    @Override
    public String[] getUserList() {
        return (String[])this.getEntries().stream().map(JsonListEntry::getUser).filter(Objects::nonNull).map(NameAndId::name).toArray(String[]::new);
    }

    @Override
    protected String getKeyForUser(NameAndId var0) {
        return var0.id().toString();
    }

    @Override
    protected /* synthetic */ String getKeyForUser(Object object) {
        return this.getKeyForUser((NameAndId)object);
    }

    @Override
    public /* synthetic */ boolean remove(Object object) {
        return this.remove((NameAndId)object);
    }
}

