/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.Objects;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.JsonList;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.server.players.NameAndId;

public class GameProfileBanList
extends JsonList<NameAndId, GameProfileBanEntry> {
    public GameProfileBanList(File var0, NotificationService var1) {
        super(var0, var1);
    }

    @Override
    protected JsonListEntry<NameAndId> createEntry(JsonObject var0) {
        return new GameProfileBanEntry(var0);
    }

    public boolean isBanned(NameAndId var0) {
        return this.contains(var0);
    }

    @Override
    public String[] getUserList() {
        return (String[])this.getEntries().stream().map(JsonListEntry::getUser).filter(Objects::nonNull).map(NameAndId::name).toArray(String[]::new);
    }

    @Override
    protected String getKeyForUser(NameAndId var0) {
        return var0.id().toString();
    }

    @Override
    public boolean add(GameProfileBanEntry var0) {
        if (super.add(var0)) {
            if (var0.getUser() != null) {
                this.notificationService.playerBanned(var0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(NameAndId var0) {
        if (super.remove(var0)) {
            this.notificationService.playerUnbanned(var0);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (GameProfileBanEntry var1 : this.getEntries()) {
            if (var1.getUser() == null) continue;
            this.notificationService.playerUnbanned((NameAndId)var1.getUser());
        }
        super.clear();
    }

    @Override
    public /* synthetic */ boolean remove(Object object) {
        return this.remove((NameAndId)object);
    }
}

