/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.JsonListEntry;
import org.jspecify.annotations.Nullable;

public abstract class ExpirableListEntry<T>
extends JsonListEntry<T> {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    public static final String EXPIRES_NEVER = "forever";
    protected final Date created;
    protected final String source;
    protected final @Nullable Date expires;
    protected final @Nullable String reason;

    public ExpirableListEntry(@Nullable T var0, @Nullable Date var1, @Nullable String var2, @Nullable Date var3, @Nullable String var4) {
        super(var0);
        this.created = var1 == null ? new Date() : var1;
        this.source = var2 == null ? "(Unknown)" : var2;
        this.expires = var3;
        this.reason = var4;
    }

    protected ExpirableListEntry(@Nullable T var0, JsonObject var1) {
        super(var0);
        Date var3;
        Date var2;
        try {
            var2 = var1.has("created") ? DATE_FORMAT.parse(var1.get("created").getAsString()) : new Date();
        }
        catch (ParseException var32) {
            var2 = new Date();
        }
        this.created = var2;
        this.source = var1.has("source") ? var1.get("source").getAsString() : "(Unknown)";
        try {
            var3 = var1.has("expires") ? DATE_FORMAT.parse(var1.get("expires").getAsString()) : null;
        }
        catch (ParseException var4) {
            var3 = null;
        }
        this.expires = var3;
        this.reason = var1.has("reason") ? var1.get("reason").getAsString() : null;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getSource() {
        return this.source;
    }

    public @Nullable Date getExpires() {
        return this.expires;
    }

    public @Nullable String getReason() {
        return this.reason;
    }

    public IChatBaseComponent getReasonMessage() {
        String var0 = this.getReason();
        return var0 == null ? IChatBaseComponent.translatable("multiplayer.disconnect.banned.reason.default") : IChatBaseComponent.literal(var0);
    }

    public abstract IChatBaseComponent getDisplayName();

    @Override
    boolean hasExpired() {
        if (this.expires == null) {
            return false;
        }
        return this.expires.before(new Date());
    }

    @Override
    protected void serialize(JsonObject var0) {
        var0.addProperty("created", DATE_FORMAT.format(this.created));
        var0.addProperty("source", this.source);
        var0.addProperty("expires", this.expires == null ? EXPIRES_NEVER : DATE_FORMAT.format(this.expires));
        var0.addProperty("reason", this.reason);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        ExpirableListEntry var1 = (ExpirableListEntry)var0;
        return Objects.equals(this.source, var1.source) && Objects.equals(this.expires, var1.expires) && Objects.equals(this.reason, var1.reason) && Objects.equals(this.getUser(), var1.getUser());
    }
}

