/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.permissions;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.minecraft.server.permissions.Permission;
import net.minecraft.server.permissions.PermissionSet;

public class PermissionSetUnion
implements PermissionSet {
    private final ReferenceSet<PermissionSet> permissions = new ReferenceArraySet();

    PermissionSetUnion(PermissionSet var0, PermissionSet var1) {
        this.permissions.add((Object)var0);
        this.permissions.add((Object)var1);
        this.ensureNoUnionsWithinUnions();
    }

    private PermissionSetUnion(ReferenceSet<PermissionSet> var0, PermissionSet var1) {
        this.permissions.addAll(var0);
        this.permissions.add((Object)var1);
        this.ensureNoUnionsWithinUnions();
    }

    private PermissionSetUnion(ReferenceSet<PermissionSet> var0, ReferenceSet<PermissionSet> var1) {
        this.permissions.addAll(var0);
        this.permissions.addAll(var1);
        this.ensureNoUnionsWithinUnions();
    }

    @Override
    public boolean hasPermission(Permission var0) {
        for (PermissionSet var2 : this.permissions) {
            if (!var2.hasPermission(var0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PermissionSet union(PermissionSet var0) {
        if (var0 instanceof PermissionSetUnion) {
            PermissionSetUnion var1 = (PermissionSetUnion)var0;
            return new PermissionSetUnion(this.permissions, var1.permissions);
        }
        return new PermissionSetUnion(this.permissions, var0);
    }

    @VisibleForTesting
    public ReferenceSet<PermissionSet> getPermissions() {
        return new ReferenceArraySet(this.permissions);
    }

    private void ensureNoUnionsWithinUnions() {
        for (PermissionSet var1 : this.permissions) {
            if (!(var1 instanceof PermissionSetUnion)) continue;
            throw new IllegalArgumentException("Cannot have PermissionSetUnion within another PermissionSetUnion");
        }
    }
}

