/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.ResourcePackVanilla;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import net.minecraft.world.level.validation.DirectoryValidator;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class BuiltInPackSource
implements ResourcePackSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String VANILLA_ID = "vanilla";
    public static final String TESTS_ID = "tests";
    public static final KnownPack CORE_PACK_INFO = KnownPack.vanilla("core");
    private final EnumResourcePackType packType;
    private final ResourcePackVanilla vanillaPack;
    private final MinecraftKey packDir;
    private final DirectoryValidator validator;

    public BuiltInPackSource(EnumResourcePackType var0, ResourcePackVanilla var1, MinecraftKey var2, DirectoryValidator var3) {
        this.packType = var0;
        this.vanillaPack = var1;
        this.packDir = var2;
        this.validator = var3;
    }

    @Override
    public void loadPacks(Consumer<ResourcePackLoader> var0) {
        ResourcePackLoader var1 = this.createVanillaPack(this.vanillaPack);
        if (var1 != null) {
            var0.accept(var1);
        }
        this.listBundledPacks(var0);
    }

    protected abstract @Nullable ResourcePackLoader createVanillaPack(IResourcePack var1);

    protected abstract IChatBaseComponent getPackTitle(String var1);

    public ResourcePackVanilla getVanillaPack() {
        return this.vanillaPack;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void listBundledPacks(Consumer<ResourcePackLoader> var0) {
        HashMap<String, @Nullable Function> var12 = new HashMap<String, Function>();
        this.populatePackList(var12::put);
        var12.forEach((var1, var2) -> {
            ResourcePackLoader var3 = (ResourcePackLoader)var2.apply(var1);
            if (var3 != null) {
                var0.accept(var3);
            }
        });
    }

    protected void populatePackList(BiConsumer<String, Function<String, ResourcePackLoader>> var0) {
        this.vanillaPack.listRawPaths(this.packType, this.packDir, var1 -> this.discoverPacksInPath((Path)var1, var0));
    }

    protected void discoverPacksInPath(@Nullable Path var0, BiConsumer<String, Function<String, @Nullable ResourcePackLoader>> var1) {
        if (var0 != null && Files.isDirectory(var0, new LinkOption[0])) {
            try {
                ResourcePackSourceFolder.discoverPacks(var0, this.validator, (var12, var2) -> var1.accept(BuiltInPackSource.pathToId(var12), var1 -> this.createBuiltinPack((String)var1, (ResourcePackLoader.c)var2, this.getPackTitle((String)var1))));
            }
            catch (IOException var22) {
                LOGGER.warn("Failed to discover packs in {}", (Object)var0, (Object)var22);
            }
        }
    }

    private static String pathToId(Path var0) {
        return StringUtils.removeEnd((String)var0.getFileName().toString(), (String)".zip");
    }

    protected abstract @Nullable ResourcePackLoader createBuiltinPack(String var1, ResourcePackLoader.c var2, IChatBaseComponent var3);

    protected static ResourcePackLoader.c fixedResources(final IResourcePack var0) {
        return new ResourcePackLoader.c(){

            @Override
            public IResourcePack openPrimary(PackLocationInfo var02) {
                return var0;
            }

            @Override
            public IResourcePack openFull(PackLocationInfo var02, ResourcePackLoader.a var1) {
                return var0;
            }
        };
    }
}

