/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.Nullable;

public class CompositePackResources
implements IResourcePack {
    private final IResourcePack primaryPackResources;
    private final List<IResourcePack> packResourcesStack;

    public CompositePackResources(IResourcePack var0, List<IResourcePack> var1) {
        this.primaryPackResources = var0;
        ArrayList<IResourcePack> var2 = new ArrayList<IResourcePack>(var1.size() + 1);
        var2.addAll(Lists.reverse(var1));
        var2.add(var0);
        this.packResourcesStack = List.copyOf(var2);
    }

    @Override
    public @Nullable IoSupplier<InputStream> getRootResource(String ... var0) {
        return this.primaryPackResources.getRootResource(var0);
    }

    @Override
    public @Nullable IoSupplier<InputStream> getResource(EnumResourcePackType var0, MinecraftKey var1) {
        for (IResourcePack var3 : this.packResourcesStack) {
            IoSupplier<InputStream> var4 = var3.getResource(var0, var1);
            if (var4 == null) continue;
            return var4;
        }
        return null;
    }

    @Override
    public void listResources(EnumResourcePackType var0, String var1, String var2, IResourcePack.a var3) {
        HashMap<MinecraftKey, IoSupplier<InputStream>> var4 = new HashMap<MinecraftKey, IoSupplier<InputStream>>();
        for (IResourcePack var6 : this.packResourcesStack) {
            var6.listResources(var0, var1, var2, var4::putIfAbsent);
        }
        var4.forEach(var3);
    }

    @Override
    public Set<String> getNamespaces(EnumResourcePackType var0) {
        HashSet<String> var1 = new HashSet<String>();
        for (IResourcePack var3 : this.packResourcesStack) {
            var1.addAll(var3.getNamespaces(var0));
        }
        return var1;
    }

    @Override
    public <T> @Nullable T getMetadataSection(MetadataSectionType<T> var0) throws IOException {
        return this.primaryPackResources.getMetadataSection(var0);
    }

    @Override
    public PackLocationInfo location() {
        return this.primaryPackResources.location();
    }

    @Override
    public void close() {
        this.packResourcesStack.forEach(IResourcePack::close);
    }
}

