/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.local.LocalAddress;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.NetworkManagerServer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.EventLoopGroupHolder;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.LegacyPingHandler;
import net.minecraft.server.network.MemoryServerHandshakePacketListenerImpl;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ServerConnection {
    private static final Logger LOGGER = LogUtils.getLogger();
    final MinecraftServer server;
    public volatile boolean running;
    private final List<ChannelFuture> channels = Collections.synchronizedList(Lists.newArrayList());
    final List<NetworkManager> connections = Collections.synchronizedList(Lists.newArrayList());

    public ServerConnection(MinecraftServer var0) {
        this.server = var0;
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTcpServerListener(@Nullable InetAddress var0, int var1) throws IOException {
        List<ChannelFuture> list = this.channels;
        synchronized (list) {
            EventLoopGroupHolder var3 = EventLoopGroupHolder.remote(this.server.useNativeTransport());
            this.channels.add(((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(var3.serverChannelCls())).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel var0) {
                    try {
                        var0.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    catch (ChannelException channelException) {
                        // empty catch block
                    }
                    ChannelPipeline var1 = var0.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                    if (ServerConnection.this.server.repliesToStatus()) {
                        var1.addLast("legacy_query", (ChannelHandler)new LegacyPingHandler(ServerConnection.this.getServer()));
                    }
                    NetworkManager.configureSerialization(var1, EnumProtocolDirection.SERVERBOUND, false, null);
                    int var2 = ServerConnection.this.server.getRateLimitPacketsPerSecond();
                    NetworkManager var3 = var2 > 0 ? new NetworkManagerServer(var2) : new NetworkManager(EnumProtocolDirection.SERVERBOUND);
                    ServerConnection.this.connections.add(var3);
                    var3.configurePacketHandler(var1);
                    var3.setListenerForServerboundHandshake(new HandshakeListener(ServerConnection.this.server, var3));
                }
            }).group(var3.eventLoopGroup()).localAddress(var0, var1)).bind().syncUninterruptibly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress startMemoryChannel() {
        ChannelFuture var0;
        List<ChannelFuture> list = this.channels;
        synchronized (list) {
            var0 = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(EventLoopGroupHolder.local().serverChannelCls())).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel var0) {
                    NetworkManager var1 = new NetworkManager(EnumProtocolDirection.SERVERBOUND);
                    var1.setListenerForServerboundHandshake(new MemoryServerHandshakePacketListenerImpl(ServerConnection.this.server, var1));
                    ServerConnection.this.connections.add(var1);
                    ChannelPipeline var2 = var0.pipeline();
                    NetworkManager.configureInMemoryPipeline(var2, EnumProtocolDirection.SERVERBOUND);
                    if (SharedConstants.DEBUG_FAKE_LATENCY_MS > 0) {
                        var2.addLast("latency", (ChannelHandler)new LatencySimulator(SharedConstants.DEBUG_FAKE_LATENCY_MS, SharedConstants.DEBUG_FAKE_JITTER_MS));
                    }
                    var1.configurePacketHandler(var2);
                }
            }).group(EventLoopGroupHolder.local().eventLoopGroup()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
            this.channels.add(var0);
        }
        return var0.channel().localAddress();
    }

    public void stop() {
        this.running = false;
        for (ChannelFuture var1 : this.channels) {
            try {
                var1.channel().close().sync();
            }
            catch (InterruptedException var2) {
                LOGGER.error("Interrupted whilst closing channel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<NetworkManager> list = this.connections;
        synchronized (list) {
            Iterator<NetworkManager> var1 = this.connections.iterator();
            while (var1.hasNext()) {
                NetworkManager var2 = var1.next();
                if (var2.isConnecting()) continue;
                if (var2.isConnected()) {
                    try {
                        var2.tick();
                    }
                    catch (Exception var3) {
                        if (var2.isMemoryConnection()) {
                            throw new ReportedException(CrashReport.forThrowable(var3, "Ticking memory connection"));
                        }
                        LOGGER.warn("Failed to handle packet for {}", (Object)var2.getLoggableAddress(this.server.logIPs()), (Object)var3);
                        IChatMutableComponent var4 = IChatBaseComponent.literal("Internal server error");
                        var2.send(new ClientboundDisconnectPacket(var4), PacketSendListener.thenRun(() -> var2.disconnect(var4)));
                        var2.setReadOnly();
                    }
                    continue;
                }
                var1.remove();
                var2.handleDisconnection();
            }
        }
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public List<NetworkManager> getConnections() {
        return this.connections;
    }

    static class LatencySimulator
    extends ChannelInboundHandlerAdapter {
        private static final Timer TIMER = new HashedWheelTimer();
        private final int delay;
        private final int jitter;
        private final List<DelayedMessage> queuedMessages = Lists.newArrayList();

        public LatencySimulator(int var0, int var1) {
            this.delay = var0;
            this.jitter = var1;
        }

        public void channelRead(ChannelHandlerContext var0, Object var1) {
            this.delayDownstream(var0, var1);
        }

        private void delayDownstream(ChannelHandlerContext var0, Object var1) {
            int var2 = this.delay + (int)(Math.random() * (double)this.jitter);
            this.queuedMessages.add(new DelayedMessage(var0, var1));
            TIMER.newTimeout(this::onTimeout, (long)var2, TimeUnit.MILLISECONDS);
        }

        private void onTimeout(Timeout var0) {
            DelayedMessage var1 = this.queuedMessages.remove(0);
            var1.ctx.fireChannelRead(var1.msg);
        }

        static class DelayedMessage {
            public final ChannelHandlerContext ctx;
            public final Object msg;

            public DelayedMessage(ChannelHandlerContext var0, Object var1) {
                this.ctx = var0;
                this.msg = var1;
            }
        }
    }
}

