/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;

public final class TicketType
extends Record {
    public long timeout;
    @a
    private final int flags;
    public static final long NO_TIMEOUT = 0L;
    public static final int FLAG_PERSIST = 1;
    public static final int FLAG_LOADING = 2;
    public static final int FLAG_SIMULATION = 4;
    public static final int FLAG_KEEP_DIMENSION_ACTIVE = 8;
    public static final int FLAG_CAN_EXPIRE_IF_UNLOADED = 16;
    public static final TicketType PLAYER_SPAWN = TicketType.register("player_spawn", 20L, 2);
    public static final TicketType SPAWN_SEARCH = TicketType.register("spawn_search", 1L, 2);
    public static final TicketType DRAGON = TicketType.register("dragon", 0L, 6);
    public static final TicketType PLAYER_LOADING = TicketType.register("player_loading", 0L, 2);
    public static final TicketType PLAYER_SIMULATION = TicketType.register("player_simulation", 0L, 12);
    public static final TicketType FORCED = TicketType.register("forced", 0L, 15);
    public static final TicketType PORTAL = TicketType.register("portal", 300L, 15);
    public static final TicketType ENDER_PEARL = TicketType.register("ender_pearl", 40L, 14);
    public static final TicketType UNKNOWN = TicketType.register("unknown", 1L, 18);

    public TicketType(long var0, @a int var2) {
        this.timeout = var0;
        this.flags = var2;
    }

    private static TicketType register(String var0, long var1, @a int var3) {
        return IRegistry.register(BuiltInRegistries.TICKET_TYPE, var0, new TicketType(var1, var3));
    }

    public boolean persist() {
        return (this.flags & 1) != 0;
    }

    public boolean doesLoad() {
        return (this.flags & 2) != 0;
    }

    public boolean doesSimulate() {
        return (this.flags & 4) != 0;
    }

    public boolean shouldKeepDimensionActive() {
        return (this.flags & 8) != 0;
    }

    public boolean canExpireIfUnloaded() {
        return (this.flags & 0x10) != 0;
    }

    public boolean hasTimeout() {
        return this.timeout != 0L;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TicketType.class, "timeout;flags", "timeout", "flags"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TicketType.class, "timeout;flags", "timeout", "flags"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TicketType.class, "timeout;flags", "timeout", "flags"}, this, var0);
    }

    public long timeout() {
        return this.timeout;
    }

    @a
    public int flags() {
        return this.flags;
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.METHOD, ElementType.TYPE_USE})
    public static @interface a {
    }
}

