/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.Message;
import net.minecraft.server.level.EntityPlayer;
import org.jspecify.annotations.Nullable;

public class PlayerService {
    private static final IChatBaseComponent DEFAULT_KICK_MESSAGE = IChatBaseComponent.translatable("multiplayer.disconnect.kicked");

    public static List<PlayerDto> get(MinecraftApi var0) {
        return var0.playerListService().getPlayers().stream().map(PlayerDto::from).toList();
    }

    public static List<PlayerDto> kick(MinecraftApi var0, List<a> var1, ClientInfo var2) {
        ArrayList<PlayerDto> var3 = new ArrayList<PlayerDto>();
        for (a var5 : var1) {
            EntityPlayer var6 = PlayerService.getServerPlayer(var0, var5.player());
            if (var6 == null) continue;
            var0.playerListService().remove(var6, var2);
            var6.connection.disconnect(var5.message.flatMap(Message::asComponent).orElse(DEFAULT_KICK_MESSAGE));
            var3.add(var5.player());
        }
        return var3;
    }

    private static @Nullable EntityPlayer getServerPlayer(MinecraftApi var0, PlayerDto var1) {
        if (var1.id().isPresent()) {
            return var0.playerListService().getPlayer(var1.id().get());
        }
        if (var1.name().isPresent()) {
            return var0.playerListService().getPlayerByName(var1.name().get());
        }
        return null;
    }

    public static final class a
    extends Record {
        private final PlayerDto player;
        final Optional<Message> message;
        public static final MapCodec<a> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)PlayerDto.CODEC.codec().fieldOf("player").forGetter(a::player), (App)Message.CODEC.optionalFieldOf("message").forGetter(a::message)).apply((Applicative)var0, a::new));

        public a(PlayerDto var0, Optional<Message> var1) {
            this.player = var0;
            this.message = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "player;message", "player", "message"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "player;message", "player", "message"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "player;message", "player", "message"}, this, var0);
        }

        public PlayerDto player() {
            return this.player;
        }

        public Optional<Message> message() {
            return this.message;
        }
    }
}

