/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.util.SystemUtils;

public class OperatorService {
    public static List<b> get(MinecraftApi var02) {
        return var02.operatorListService().getEntries().stream().filter(var0 -> var0.getUser() != null).map(b::from).toList();
    }

    public static List<b> clear(MinecraftApi var0, ClientInfo var1) {
        var0.operatorListService().clear(var1);
        return OperatorService.get(var0);
    }

    public static List<b> remove(MinecraftApi var0, List<PlayerDto> var12, ClientInfo var22) {
        List<CompletableFuture> var3 = var12.stream().map(var1 -> var0.playerListService().getUser(var1.id(), var1.name())).toList();
        for (Optional var5 : SystemUtils.sequence(var3).join()) {
            var5.ifPresent(var2 -> var0.operatorListService().deop((NameAndId)var2, var22));
        }
        return OperatorService.get(var0);
    }

    public static List<b> add(MinecraftApi var0, List<b> var12, ClientInfo var22) {
        List<CompletableFuture> var3 = var12.stream().map(var1 -> var0.playerListService().getUser(var1.player().id(), var1.player().name()).thenApply(var12 -> var12.map(var1 -> new a((NameAndId)var1, var1.permissionLevel(), var1.bypassesPlayerLimit())))).toList();
        for (Optional var5 : SystemUtils.sequence(var3).join()) {
            var5.ifPresent(var2 -> var0.operatorListService().op(var2.user(), var2.permissionLevel(), var2.bypassesPlayerLimit(), var22));
        }
        return OperatorService.get(var0);
    }

    public static List<b> set(MinecraftApi var02, List<b> var12, ClientInfo var22) {
        List<CompletableFuture> var3 = var12.stream().map(var1 -> var02.playerListService().getUser(var1.player().id(), var1.player().name()).thenApply(var12 -> var12.map(var1 -> new a((NameAndId)var1, var1.permissionLevel(), var1.bypassesPlayerLimit())))).toList();
        Set var4 = SystemUtils.sequence(var3).join().stream().flatMap(Optional::stream).collect(Collectors.toSet());
        Set var5 = var02.operatorListService().getEntries().stream().filter(var0 -> var0.getUser() != null).map(var0 -> new a((NameAndId)var0.getUser(), Optional.of(var0.permissions().level()), Optional.of(var0.getBypassesPlayerLimit()))).collect(Collectors.toSet());
        var5.stream().filter(var1 -> !var4.contains(var1)).forEach(var2 -> var02.operatorListService().deop(var2.user(), var22));
        var4.stream().filter(var1 -> !var5.contains(var1)).forEach(var2 -> var02.operatorListService().op(var2.user(), var2.permissionLevel(), var2.bypassesPlayerLimit(), var22));
        return OperatorService.get(var02);
    }

    record a(NameAndId user, Optional<PermissionLevel> permissionLevel, Optional<Boolean> bypassesPlayerLimit) {
    }

    public record b(PlayerDto player, Optional<PermissionLevel> permissionLevel, Optional<Boolean> bypassesPlayerLimit) {
        public static final MapCodec<b> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)PlayerDto.CODEC.codec().fieldOf("player").forGetter(b::player), (App)PermissionLevel.INT_CODEC.optionalFieldOf("permissionLevel").forGetter(b::permissionLevel), (App)Codec.BOOL.optionalFieldOf("bypassesPlayerLimit").forGetter(b::bypassesPlayerLimit)).apply((Applicative)var0, b::new));

        public static b from(OpListEntry var0) {
            return new b(PlayerDto.from(Objects.requireNonNull((NameAndId)var0.getUser())), Optional.of(var0.permissions().level()), Optional.of(var0.getBypassesPlayerLimit()));
        }
    }
}

