/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.api.Schema;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import org.jspecify.annotations.Nullable;

public interface IncomingRpcMethod<Params, Result> {
    public MethodInfo<Params, Result> info();

    public a attributes();

    public JsonElement apply(MinecraftApi var1, @Nullable JsonElement var2, ClientInfo var3);

    public static <Result> b<Void, Result> method(e<Result> var0) {
        return new b(var0);
    }

    public static <Params, Result> b<Params, Result> method(f<Params, Result> var0) {
        return new b<Params, Result>(var0);
    }

    public static <Result> b<Void, Result> method(Function<MinecraftApi, Result> var0) {
        return new b(var0);
    }

    public static class b<Params, Result> {
        private String description = "";
        private @Nullable ParamInfo<Params> paramInfo;
        private @Nullable ResultInfo<Result> resultInfo;
        private boolean discoverable = true;
        private boolean runOnMainThread = true;
        private @Nullable e<Result> parameterlessFunction;
        private @Nullable f<Params, Result> parameterFunction;

        public b(e<Result> var0) {
            this.parameterlessFunction = var0;
        }

        public b(f<Params, Result> var0) {
            this.parameterFunction = var0;
        }

        public b(Function<MinecraftApi, Result> var0) {
            this.parameterlessFunction = (var1, var2) -> var0.apply(var1);
        }

        public b<Params, Result> description(String var0) {
            this.description = var0;
            return this;
        }

        public b<Params, Result> response(String var0, Schema<Result> var1) {
            this.resultInfo = new ResultInfo<Result>(var0, var1.info());
            return this;
        }

        public b<Params, Result> param(String var0, Schema<Params> var1) {
            this.paramInfo = new ParamInfo<Params>(var0, var1.info());
            return this;
        }

        public b<Params, Result> undiscoverable() {
            this.discoverable = false;
            return this;
        }

        public b<Params, Result> notOnMainThread() {
            this.runOnMainThread = false;
            return this;
        }

        public IncomingRpcMethod<Params, Result> build() {
            if (this.resultInfo == null) {
                throw new IllegalStateException("No response defined");
            }
            a var0 = new a(this.runOnMainThread, this.discoverable);
            MethodInfo<Params, Result> var1 = new MethodInfo<Params, Result>(this.description, this.paramInfo, this.resultInfo);
            if (this.parameterlessFunction != null) {
                return new d<Params, Result>(var1, var0, this.parameterlessFunction);
            }
            if (this.parameterFunction != null) {
                if (this.paramInfo == null) {
                    throw new IllegalStateException("No param schema defined");
                }
                return new c<Params, Result>(var1, var0, this.parameterFunction);
            }
            throw new IllegalStateException("No method defined");
        }

        public IncomingRpcMethod<?, ?> register(IRegistry<IncomingRpcMethod<?, ?>> var0, String var1) {
            return this.register(var0, MinecraftKey.withDefaultNamespace(var1));
        }

        private IncomingRpcMethod<?, ?> register(IRegistry<IncomingRpcMethod<?, ?>> var0, MinecraftKey var1) {
            return IRegistry.register(var0, var1, this.build());
        }
    }

    @FunctionalInterface
    public static interface e<Result> {
        public Result apply(MinecraftApi var1, ClientInfo var2);
    }

    @FunctionalInterface
    public static interface f<Params, Result> {
        public Result apply(MinecraftApi var1, Params var2, ClientInfo var3);
    }

    public record c<Params, Result>(MethodInfo<Params, Result> info, a attributes, f<Params, Result> function) implements IncomingRpcMethod<Params, Result>
    {
        @Override
        public JsonElement apply(MinecraftApi var0, @Nullable JsonElement var1, ClientInfo var2) {
            JsonElement var3;
            Object var5;
            Object var4;
            if (var1 == null || !var1.isJsonArray() && !var1.isJsonObject()) {
                throw new InvalidParameterJsonRpcException("Expected params as array or named");
            }
            if (this.info.params().isEmpty()) {
                throw new IllegalArgumentException("Method defined as having parameters without describing them");
            }
            if (var1.isJsonObject()) {
                var4 = this.info.params().get().name();
                var5 = var1.getAsJsonObject().get((String)var4);
                if (var5 == null) {
                    throw new InvalidParameterJsonRpcException(String.format(Locale.ROOT, "Params passed by-name, but expected param [%s] does not exist", var4));
                }
                var3 = var5;
            } else {
                var4 = var1.getAsJsonArray();
                if (var4.isEmpty() || var4.size() > 1) {
                    throw new InvalidParameterJsonRpcException("Expected exactly one element in the params array");
                }
                var3 = var4.get(0);
            }
            var4 = this.info.params().get().schema().codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)var3).getOrThrow(InvalidParameterJsonRpcException::new);
            var5 = this.function.apply(var0, (JsonArray)var4, var2);
            if (this.info.result().isEmpty()) {
                throw new IllegalStateException("No result codec defined");
            }
            return (JsonElement)this.info.result().get().schema().codec().encodeStart((DynamicOps)JsonOps.INSTANCE, var5).getOrThrow(EncodeJsonRpcException::new);
        }
    }

    public record d<Params, Result>(MethodInfo<Params, Result> info, a attributes, e<Result> supplier) implements IncomingRpcMethod<Params, Result>
    {
        @Override
        public JsonElement apply(MinecraftApi var0, @Nullable JsonElement var1, ClientInfo var2) {
            if (!(var1 == null || var1.isJsonArray() && var1.getAsJsonArray().isEmpty())) {
                throw new InvalidParameterJsonRpcException("Expected no params, or an empty array");
            }
            if (this.info.params().isPresent()) {
                throw new IllegalArgumentException("Parameterless method unexpectedly has parameter description");
            }
            Result var3 = this.supplier.apply(var0, var2);
            if (this.info.result().isEmpty()) {
                throw new IllegalStateException("No result codec defined");
            }
            return (JsonElement)this.info.result().get().schema().codec().encodeStart((DynamicOps)JsonOps.INSTANCE, var3).getOrThrow(InvalidParameterJsonRpcException::new);
        }
    }

    public record a(boolean runOnMainThread, boolean discoverable) {
    }
}

