/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class RaidCommand {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("raid").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_ADMINS))).then(net.minecraft.commands.CommandDispatcher.literal("start").then(net.minecraft.commands.CommandDispatcher.argument("omenlvl", IntegerArgumentType.integer((int)0)).executes(var0 -> RaidCommand.start((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"omenlvl")))))).then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> RaidCommand.stop((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("check").executes(var0 -> RaidCommand.check((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("sound").then(net.minecraft.commands.CommandDispatcher.argument("type", ArgumentChatComponent.textComponent(var1)).executes(var0 -> RaidCommand.playSound((CommandListenerWrapper)var0.getSource(), ArgumentChatComponent.getResolvedComponent((CommandContext<CommandListenerWrapper>)var0, "type")))))).then(net.minecraft.commands.CommandDispatcher.literal("spawnleader").executes(var0 -> RaidCommand.spawnLeader((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("setomen").then(net.minecraft.commands.CommandDispatcher.argument("level", IntegerArgumentType.integer((int)0)).executes(var0 -> RaidCommand.setRaidOmenLevel((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"level")))))).then(net.minecraft.commands.CommandDispatcher.literal("glow").executes(var0 -> RaidCommand.glow((CommandListenerWrapper)var0.getSource()))));
    }

    private static int glow(CommandListenerWrapper var0) throws CommandSyntaxException {
        Raid var1 = RaidCommand.getRaid(var0.getPlayerOrException());
        if (var1 != null) {
            Set<EntityRaider> var2 = var1.getAllRaiders();
            for (EntityRaider var4 : var2) {
                var4.addEffect(new MobEffect(MobEffects.GLOWING, 1000, 1));
            }
        }
        return 1;
    }

    private static int setRaidOmenLevel(CommandListenerWrapper var0, int var1) throws CommandSyntaxException {
        Raid var2 = RaidCommand.getRaid(var0.getPlayerOrException());
        if (var2 != null) {
            int var3 = var2.getMaxRaidOmenLevel();
            if (var1 > var3) {
                var0.sendFailure(IChatBaseComponent.literal("Sorry, the max raid omen level you can set is " + var3));
            } else {
                int var4 = var2.getRaidOmenLevel();
                var2.setRaidOmenLevel(var1);
                var0.sendSuccess(() -> IChatBaseComponent.literal("Changed village's raid omen level from " + var4 + " to " + var1), false);
            }
        } else {
            var0.sendFailure(IChatBaseComponent.literal("No raid found here"));
        }
        return 1;
    }

    private static int spawnLeader(CommandListenerWrapper var0) {
        var0.sendSuccess(() -> IChatBaseComponent.literal("Spawned a raid captain"), false);
        EntityRaider var1 = EntityTypes.PILLAGER.create(var0.getLevel(), EntitySpawnReason.COMMAND);
        if (var1 == null) {
            var0.sendFailure(IChatBaseComponent.literal("Pillager failed to spawn"));
            return 0;
        }
        var1.setPatrolLeader(true);
        var1.setItemSlot(EnumItemSlot.HEAD, Raid.getOminousBannerInstance(var0.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        var1.setPos(var0.getPosition().x, var0.getPosition().y, var0.getPosition().z);
        var1.finalizeSpawn(var0.getLevel(), var0.getLevel().getCurrentDifficultyAt(BlockPosition.containing(var0.getPosition())), EntitySpawnReason.COMMAND, null);
        var0.getLevel().addFreshEntityWithPassengers(var1);
        return 1;
    }

    private static int playSound(CommandListenerWrapper var0, @Nullable IChatBaseComponent var1) {
        if (var1 != null && var1.getString().equals("local")) {
            WorldServer var2 = var0.getLevel();
            Vec3D var3 = var0.getPosition().add(5.0, 0.0, 0.0);
            var2.playSeededSound(null, var3.x, var3.y, var3.z, SoundEffects.RAID_HORN, SoundCategory.NEUTRAL, 2.0f, 1.0f, var2.random.nextLong());
        }
        return 1;
    }

    private static int start(CommandListenerWrapper var0, int var1) throws CommandSyntaxException {
        EntityPlayer var2 = var0.getPlayerOrException();
        BlockPosition var3 = var2.blockPosition();
        if (var2.level().isRaided(var3)) {
            var0.sendFailure(IChatBaseComponent.literal("Raid already started close by"));
            return -1;
        }
        PersistentRaid var4 = var2.level().getRaids();
        Raid var5 = var4.createOrExtendRaid(var2, var2.blockPosition());
        if (var5 != null) {
            var5.setRaidOmenLevel(var1);
            var4.setDirty();
            var0.sendSuccess(() -> IChatBaseComponent.literal("Created a raid in your local village"), false);
        } else {
            var0.sendFailure(IChatBaseComponent.literal("Failed to create a raid in your local village"));
        }
        return 1;
    }

    private static int stop(CommandListenerWrapper var0) throws CommandSyntaxException {
        EntityPlayer var1 = var0.getPlayerOrException();
        BlockPosition var2 = var1.blockPosition();
        Raid var3 = var1.level().getRaidAt(var2);
        if (var3 != null) {
            var3.stop();
            var0.sendSuccess(() -> IChatBaseComponent.literal("Stopped raid"), false);
            return 1;
        }
        var0.sendFailure(IChatBaseComponent.literal("No raid here"));
        return -1;
    }

    private static int check(CommandListenerWrapper var0) throws CommandSyntaxException {
        Raid var1 = RaidCommand.getRaid(var0.getPlayerOrException());
        if (var1 != null) {
            StringBuilder var2 = new StringBuilder();
            var2.append("Found a started raid! ");
            var0.sendSuccess(() -> IChatBaseComponent.literal(var2.toString()), false);
            StringBuilder var3 = new StringBuilder();
            var3.append("Num groups spawned: ");
            var3.append(var1.getGroupsSpawned());
            var3.append(" Raid omen level: ");
            var3.append(var1.getRaidOmenLevel());
            var3.append(" Num mobs: ");
            var3.append(var1.getTotalRaidersAlive());
            var3.append(" Raid health: ");
            var3.append(var1.getHealthOfLivingRaiders());
            var3.append(" / ");
            var3.append(var1.getTotalHealth());
            var0.sendSuccess(() -> IChatBaseComponent.literal(var3.toString()), false);
            return 1;
        }
        var0.sendFailure(IChatBaseComponent.literal("Found no started raids"));
        return 0;
    }

    private static @Nullable Raid getRaid(EntityPlayer var0) {
        return var0.level().getRaidAt(var0.blockPosition());
    }
}

