/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FileZipper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class PerfCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_NOT_RUNNING = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.perf.notRunning"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_RUNNING = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.perf.alreadyRunning"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("perf").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_OWNERS))).then(net.minecraft.commands.CommandDispatcher.literal("start").executes(var0 -> PerfCommand.startProfilingDedicatedServer((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> PerfCommand.stopProfilingDedicatedServer((CommandListenerWrapper)var0.getSource()))));
    }

    private static int startProfilingDedicatedServer(CommandListenerWrapper var0) throws CommandSyntaxException {
        MinecraftServer var12 = var0.getServer();
        if (var12.isRecordingMetrics()) {
            throw ERROR_ALREADY_RUNNING.create();
        }
        Consumer<MethodProfilerResults> var22 = var1 -> PerfCommand.whenStopped(var0, var1);
        Consumer<Path> var3 = var2 -> PerfCommand.saveResults(var0, var2, var12);
        var12.startRecordingMetrics(var22, var3);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.perf.started"), false);
        return 0;
    }

    private static int stopProfilingDedicatedServer(CommandListenerWrapper var0) throws CommandSyntaxException {
        MinecraftServer var1 = var0.getServer();
        if (!var1.isRecordingMetrics()) {
            throw ERROR_NOT_RUNNING.create();
        }
        var1.finishRecordingMetrics();
        return 0;
    }

    private static void saveResults(CommandListenerWrapper var0, Path var1, MinecraftServer var2) {
        String var4;
        String var3 = String.format(Locale.ROOT, "%s-%s-%s", SystemUtils.getFilenameFormattedDateTime(), var2.getWorldData().getLevelName(), SharedConstants.getCurrentVersion().id());
        try {
            var4 = net.minecraft.util.FileUtils.findAvailableName(MetricsPersister.PROFILING_RESULTS_DIR, var3, ".zip");
        }
        catch (IOException var5) {
            var0.sendFailure(IChatBaseComponent.translatable("commands.perf.reportFailed"));
            LOGGER.error("Failed to create report name", (Throwable)var5);
            return;
        }
        try (FileZipper var5 = new FileZipper(MetricsPersister.PROFILING_RESULTS_DIR.resolve(var4));){
            var5.add(Paths.get("system.txt", new String[0]), var2.fillSystemReport(new SystemReport()).toLineSeparatedString());
            var5.add(var1);
        }
        try {
            FileUtils.forceDelete((File)var1.toFile());
        }
        catch (IOException var6) {
            LOGGER.warn("Failed to delete temporary profiling file {}", (Object)var1, (Object)var6);
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.perf.reportSaved", var4), false);
    }

    private static void whenStopped(CommandListenerWrapper var0, MethodProfilerResults var1) {
        if (var1 == MethodProfilerResultsEmpty.EMPTY) {
            return;
        }
        int var2 = var1.getTickDuration();
        double var3 = (double)var1.getNanoDuration() / (double)TimeRange.NANOSECONDS_PER_SECOND;
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.perf.stopped", String.format(Locale.ROOT, "%.2f", var3), var2, String.format(Locale.ROOT, "%.2f", (double)var2 / var3)), false);
    }
}

