/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec2F;

public class CommandSpawnpoint {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("spawnpoint").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).executes(var0 -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)var0.getSource(), Collections.singleton(((CommandListenerWrapper)var0.getSource()).getPlayerOrException()), BlockPosition.containing(((CommandListenerWrapper)var0.getSource()).getPosition()), VectorPosition.ZERO_ROTATION))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).executes(var0 -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), BlockPosition.containing(((CommandListenerWrapper)var0.getSource()).getPosition()), VectorPosition.ZERO_ROTATION))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(var0 -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentPosition.getSpawnablePos((CommandContext<CommandListenerWrapper>)var0, "pos"), VectorPosition.ZERO_ROTATION))).then(net.minecraft.commands.CommandDispatcher.argument("rotation", ArgumentRotation.rotation()).executes(var0 -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentPosition.getSpawnablePos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentRotation.getRotation((CommandContext<CommandListenerWrapper>)var0, "rotation")))))));
    }

    private static int setSpawn(CommandListenerWrapper var0, Collection<EntityPlayer> var1, BlockPosition var2, IVectorPosition var3) {
        ResourceKey<World> var4 = var0.getLevel().dimension();
        Vec2F var5 = var3.getRotation(var0);
        float var6 = MathHelper.wrapDegrees(var5.y);
        float var7 = MathHelper.clamp(var5.x, -90.0f, 90.0f);
        for (EntityPlayer var9 : var1) {
            var9.setRespawnPosition(new EntityPlayer.RespawnConfig(WorldData.a.of(var4, var2, var6, var7), true), false);
        }
        String var8 = var4.identifier().toString();
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.spawnpoint.success.single", var2.getX(), var2.getY(), var2.getZ(), Float.valueOf(var6), Float.valueOf(var7), var8, ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.spawnpoint.success.multiple", var2.getX(), var2.getY(), var2.getZ(), Float.valueOf(var6), Float.valueOf(var7), var8, var1.size()), true);
        }
        return var1.size();
    }
}

