/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.net.InetAddresses;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.IpBanList;

public class CommandPardonIP {
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.pardonip.invalid"));
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.pardonip.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("pardon-ip").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_ADMINS))).then(net.minecraft.commands.CommandDispatcher.argument("target", StringArgumentType.word()).suggests((var0, var1) -> ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getIpBans().getUserList(), var1)).executes(var0 -> CommandPardonIP.unban((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"target")))));
    }

    private static int unban(CommandListenerWrapper var0, String var1) throws CommandSyntaxException {
        if (!InetAddresses.isInetAddress((String)var1)) {
            throw ERROR_INVALID.create();
        }
        IpBanList var2 = var0.getServer().getPlayerList().getIpBans();
        if (!var2.isBanned(var1)) {
            throw ERROR_NOT_BANNED.create();
        }
        var2.remove(var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.pardonip.success", var1), true);
        return 1;
    }
}

