/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class AdvancementDataWorld
extends ResourceDataJson<Advancement> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Map<MinecraftKey, AdvancementHolder> advancements = Map.of();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.a registries;

    public AdvancementDataWorld(HolderLookup.a var0) {
        super(var0, Advancement.CODEC, Registries.ADVANCEMENT);
        this.registries = var0;
    }

    @Override
    protected void apply(Map<MinecraftKey, Advancement> var0, IResourceManager var12, GameProfilerFiller var22) {
        ImmutableMap.Builder var3 = ImmutableMap.builder();
        var0.forEach((var1, var2) -> {
            this.validate((MinecraftKey)var1, (Advancement)var2);
            var3.put(var1, (Object)new AdvancementHolder((MinecraftKey)var1, (Advancement)var2));
        });
        this.advancements = var3.buildOrThrow();
        AdvancementTree var4 = new AdvancementTree();
        var4.addAll(this.advancements.values());
        for (AdvancementNode var6 : var4.roots()) {
            if (!var6.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(var6);
        }
        this.tree = var4;
    }

    private void validate(MinecraftKey var0, Advancement var1) {
        ProblemReporter.a var2 = new ProblemReporter.a();
        var1.validate(var2, this.registries);
        if (!var2.isEmpty()) {
            LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)var0, (Object)var2.getReport());
        }
    }

    public @Nullable AdvancementHolder get(MinecraftKey var0) {
        return this.advancements.get(var0);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

