/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.util.ClassTreeIdRegistry;
import org.apache.commons.lang3.ObjectUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class DataWatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_ID_VALUE = 254;
    static final ClassTreeIdRegistry ID_REGISTRY = new ClassTreeIdRegistry();
    private final SyncedDataHolder entity;
    private final Item<?>[] itemsById;
    private boolean isDirty;

    DataWatcher(SyncedDataHolder var0, Item<?>[] var1) {
        this.entity = var0;
        this.itemsById = var1;
    }

    public static <T> DataWatcherObject<T> defineId(Class<? extends SyncedDataHolder> var0, DataWatcherSerializer<T> var1) {
        int var2;
        if (LOGGER.isDebugEnabled()) {
            try {
                Class<?> var22 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!var22.equals(var0)) {
                    LOGGER.debug("defineId called for: {} from {}", new Object[]{var0, var22, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException var22) {
                // empty catch block
            }
        }
        if ((var2 = ID_REGISTRY.define(var0)) > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + var2 + "! (Max is 254)");
        }
        return var1.createAccessor(var2);
    }

    private <T> Item<T> getItem(DataWatcherObject<T> var0) {
        return this.itemsById[var0.id()];
    }

    public <T> T get(DataWatcherObject<T> var0) {
        return this.getItem(var0).getValue();
    }

    public <T> void set(DataWatcherObject<T> var0, T var1) {
        this.set(var0, var1, false);
    }

    public <T> void set(DataWatcherObject<T> var0, T var1, boolean var2) {
        Item<T> var3 = this.getItem(var0);
        if (var2 || ObjectUtils.notEqual(var1, var3.getValue())) {
            var3.setValue(var1);
            this.entity.onSyncedDataUpdated(var0);
            var3.setDirty(true);
            this.isDirty = true;
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public @Nullable List<c<?>> packDirty() {
        if (!this.isDirty) {
            return null;
        }
        this.isDirty = false;
        ArrayList var0 = new ArrayList();
        for (Item<?> var4 : this.itemsById) {
            if (!var4.isDirty()) continue;
            var4.setDirty(false);
            var0.add(var4.value());
        }
        return var0;
    }

    public @Nullable List<c<?>> getNonDefaultValues() {
        ArrayList var0 = null;
        for (Item<?> var4 : this.itemsById) {
            if (var4.isSetToDefault()) continue;
            if (var0 == null) {
                var0 = new ArrayList();
            }
            var0.add(var4.value());
        }
        return var0;
    }

    public void assignValues(List<c<?>> var0) {
        for (c<?> var2 : var0) {
            Item<?> var3 = this.itemsById[var2.id];
            this.assignValue(var3, var2);
            this.entity.onSyncedDataUpdated(var3.getAccessor());
        }
        this.entity.onSyncedDataUpdated(var0);
    }

    private <T> void assignValue(Item<T> var0, c<?> var1) {
        if (!Objects.equals(var1.serializer(), var0.accessor.serializer())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", var0.accessor.id(), this.entity, var0.value, var0.value.getClass(), var1.value, var1.value.getClass()));
        }
        var0.setValue(var1.value);
    }

    public static class Item<T> {
        final DataWatcherObject<T> accessor;
        T value;
        private final T initialValue;
        private boolean dirty;

        public Item(DataWatcherObject<T> var0, T var1) {
            this.accessor = var0;
            this.initialValue = var1;
            this.value = var1;
        }

        public DataWatcherObject<T> getAccessor() {
            return this.accessor;
        }

        public void setValue(T var0) {
            this.value = var0;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean var0) {
            this.dirty = var0;
        }

        public boolean isSetToDefault() {
            return this.initialValue.equals(this.value);
        }

        public c<T> value() {
            return c.create(this.accessor, this.value);
        }
    }

    public static final class c<T>
    extends Record {
        final int id;
        private final DataWatcherSerializer<T> serializer;
        final T value;

        public c(int var0, DataWatcherSerializer<T> var1, T var2) {
            this.id = var0;
            this.serializer = var1;
            this.value = var2;
        }

        public static <T> c<T> create(DataWatcherObject<T> var0, T var1) {
            DataWatcherSerializer<T> var2 = var0.serializer();
            return new c<T>(var0.id(), var2, var2.copy(var1));
        }

        public void write(RegistryFriendlyByteBuf var0) {
            int var1 = DataWatcherRegistry.getSerializedId(this.serializer);
            if (var1 < 0) {
                throw new EncoderException("Unknown serializer type " + String.valueOf(this.serializer));
            }
            var0.writeByte(this.id);
            var0.writeVarInt(var1);
            this.serializer.codec().encode(var0, this.value);
        }

        public static c<?> read(RegistryFriendlyByteBuf var0, int var1) {
            int var2 = var0.readVarInt();
            DataWatcherSerializer<?> var3 = DataWatcherRegistry.getSerializer(var2);
            if (var3 == null) {
                throw new DecoderException("Unknown serializer type " + var2);
            }
            return c.read(var0, var1, var3);
        }

        private static <T> c<T> read(RegistryFriendlyByteBuf var0, int var1, DataWatcherSerializer<T> var2) {
            return new c<T>(var1, var2, var2.codec().decode(var0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "id;serializer;value", "id", "serializer", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "id;serializer;value", "id", "serializer", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "id;serializer;value", "id", "serializer", "value"}, this, var0);
        }

        public int id() {
            return this.id;
        }

        public DataWatcherSerializer<T> serializer() {
            return this.serializer;
        }

        public T value() {
            return this.value;
        }
    }

    public static class a {
        private final SyncedDataHolder entity;
        private final @Nullable Item<?>[] itemsById;

        public a(SyncedDataHolder var0) {
            this.entity = var0;
            this.itemsById = new Item[ID_REGISTRY.getCount(var0.getClass())];
        }

        public <T> a define(DataWatcherObject<T> var0, T var1) {
            int var2 = var0.id();
            if (var2 > this.itemsById.length) {
                throw new IllegalArgumentException("Data value id is too big with " + var2 + "! (Max is " + this.itemsById.length + ")");
            }
            if (this.itemsById[var2] != null) {
                throw new IllegalArgumentException("Duplicate id value for " + var2 + "!");
            }
            if (DataWatcherRegistry.getSerializedId(var0.serializer()) < 0) {
                throw new IllegalArgumentException("Unregistered serializer " + String.valueOf(var0.serializer()) + " for " + var2 + "!");
            }
            this.itemsById[var0.id()] = new Item<T>(var0, var1);
            return this;
        }

        public DataWatcher build() {
            for (int var0 = 0; var0 < this.itemsById.length; ++var0) {
                if (this.itemsById[var0] != null) continue;
                throw new IllegalStateException("Entity " + String.valueOf(this.entity.getClass()) + " has not defined synched data value " + var0);
            }
            return new DataWatcher(this.entity, this.itemsById);
        }
    }
}

