/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import org.jspecify.annotations.Nullable;

public class PacketPlayOutStopSound
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutStopSound> STREAM_CODEC = Packet.codec(PacketPlayOutStopSound::write, PacketPlayOutStopSound::new);
    private static final int HAS_SOURCE = 1;
    private static final int HAS_SOUND = 2;
    private final @Nullable MinecraftKey name;
    private final @Nullable SoundCategory source;

    public PacketPlayOutStopSound(@Nullable MinecraftKey var0, @Nullable SoundCategory var1) {
        this.name = var0;
        this.source = var1;
    }

    private PacketPlayOutStopSound(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        this.source = (var1 & 1) > 0 ? var0.readEnum(SoundCategory.class) : null;
        this.name = (var1 & 2) > 0 ? var0.readIdentifier() : null;
    }

    private void write(PacketDataSerializer var0) {
        if (this.source != null) {
            if (this.name != null) {
                var0.writeByte(3);
                var0.writeEnum(this.source);
                var0.writeIdentifier(this.name);
            } else {
                var0.writeByte(1);
                var0.writeEnum(this.source);
            }
        } else if (this.name != null) {
            var0.writeByte(2);
            var0.writeIdentifier(this.name);
        } else {
            var0.writeByte(0);
        }
    }

    @Override
    public PacketType<PacketPlayOutStopSound> type() {
        return GamePacketTypes.CLIENTBOUND_STOP_SOUND;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleStopSoundEvent(this);
    }

    public @Nullable MinecraftKey getName() {
        return this.name;
    }

    public @Nullable SoundCategory getSource() {
        return this.source;
    }
}

