/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;

public class PacketPlayInSetJigsaw
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayInSetJigsaw> STREAM_CODEC = Packet.codec(PacketPlayInSetJigsaw::write, PacketPlayInSetJigsaw::new);
    private final BlockPosition pos;
    private final MinecraftKey name;
    private final MinecraftKey target;
    private final MinecraftKey pool;
    private final String finalState;
    private final TileEntityJigsaw.JointType joint;
    private final int selectionPriority;
    private final int placementPriority;

    public PacketPlayInSetJigsaw(BlockPosition var0, MinecraftKey var1, MinecraftKey var2, MinecraftKey var3, String var4, TileEntityJigsaw.JointType var5, int var6, int var7) {
        this.pos = var0;
        this.name = var1;
        this.target = var2;
        this.pool = var3;
        this.finalState = var4;
        this.joint = var5;
        this.selectionPriority = var6;
        this.placementPriority = var7;
    }

    private PacketPlayInSetJigsaw(PacketDataSerializer var0) {
        this.pos = var0.readBlockPos();
        this.name = var0.readIdentifier();
        this.target = var0.readIdentifier();
        this.pool = var0.readIdentifier();
        this.finalState = var0.readUtf();
        this.joint = TileEntityJigsaw.JointType.CODEC.byName(var0.readUtf(), TileEntityJigsaw.JointType.ALIGNED);
        this.selectionPriority = var0.readVarInt();
        this.placementPriority = var0.readVarInt();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeBlockPos(this.pos);
        var0.writeIdentifier(this.name);
        var0.writeIdentifier(this.target);
        var0.writeIdentifier(this.pool);
        var0.writeUtf(this.finalState);
        var0.writeUtf(this.joint.getSerializedName());
        var0.writeVarInt(this.selectionPriority);
        var0.writeVarInt(this.placementPriority);
    }

    @Override
    public PacketType<PacketPlayInSetJigsaw> type() {
        return GamePacketTypes.SERVERBOUND_SET_JIGSAW_BLOCK;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleSetJigsawBlock(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public MinecraftKey getName() {
        return this.name;
    }

    public MinecraftKey getTarget() {
        return this.target;
    }

    public MinecraftKey getPool() {
        return this.pool;
    }

    public String getFinalState() {
        return this.finalState;
    }

    public TileEntityJigsaw.JointType getJoint() {
        return this.joint;
    }

    public int getSelectionPriority() {
        return this.selectionPriority;
    }

    public int getPlacementPriority() {
        return this.placementPriority;
    }
}

