/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartCommandBlock;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.World;
import org.jspecify.annotations.Nullable;

public class PacketPlayInSetCommandMinecart
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayInSetCommandMinecart> STREAM_CODEC = Packet.codec(PacketPlayInSetCommandMinecart::write, PacketPlayInSetCommandMinecart::new);
    private final int entity;
    private final String command;
    private final boolean trackOutput;

    public PacketPlayInSetCommandMinecart(int var0, String var1, boolean var2) {
        this.entity = var0;
        this.command = var1;
        this.trackOutput = var2;
    }

    private PacketPlayInSetCommandMinecart(PacketDataSerializer var0) {
        this.entity = var0.readVarInt();
        this.command = var0.readUtf();
        this.trackOutput = var0.readBoolean();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.entity);
        var0.writeUtf(this.command);
        var0.writeBoolean(this.trackOutput);
    }

    @Override
    public PacketType<PacketPlayInSetCommandMinecart> type() {
        return GamePacketTypes.SERVERBOUND_SET_COMMAND_MINECART;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleSetCommandMinecart(this);
    }

    public @Nullable CommandBlockListenerAbstract getCommandBlock(World var0) {
        Entity var1 = var0.getEntity(this.entity);
        if (var1 instanceof EntityMinecartCommandBlock) {
            return ((EntityMinecartCommandBlock)var1).getCommandBlock();
        }
        return null;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }
}

