/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class ClientboundProjectilePowerPacket
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, ClientboundProjectilePowerPacket> STREAM_CODEC = Packet.codec(ClientboundProjectilePowerPacket::write, ClientboundProjectilePowerPacket::new);
    private final int id;
    private final double accelerationPower;

    public ClientboundProjectilePowerPacket(int var0, double var1) {
        this.id = var0;
        this.accelerationPower = var1;
    }

    private ClientboundProjectilePowerPacket(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        this.accelerationPower = var0.readDouble();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        var0.writeDouble(this.accelerationPower);
    }

    @Override
    public PacketType<ClientboundProjectilePowerPacket> type() {
        return GamePacketTypes.CLIENTBOUND_PROJECTILE_POWER;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleProjectilePowerPacket(this);
    }

    public int getId() {
        return this.id;
    }

    public double getAccelerationPower() {
        return this.accelerationPower;
    }
}

