/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import org.jspecify.annotations.Nullable;

public record ClientboundPlayerChatPacket(int globalIndex, UUID sender, int index, @Nullable MessageSignature signature, SignedMessageBody.a body, @Nullable IChatBaseComponent unsignedContent, FilterMask filterMask, ChatMessageType.a chatType) implements Packet<PacketListenerPlayOut>
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundPlayerChatPacket> STREAM_CODEC = Packet.codec(ClientboundPlayerChatPacket::write, ClientboundPlayerChatPacket::new);

    private ClientboundPlayerChatPacket(RegistryFriendlyByteBuf var0) {
        this(var0.readVarInt(), var0.readUUID(), var0.readVarInt(), var0.readNullable(MessageSignature::read), new SignedMessageBody.a(var0), PacketDataSerializer.readNullable(var0, ComponentSerialization.TRUSTED_STREAM_CODEC), FilterMask.read(var0), (ChatMessageType.a)ChatMessageType.a.STREAM_CODEC.decode(var0));
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeVarInt(this.globalIndex);
        var0.writeUUID(this.sender);
        var0.writeVarInt(this.index);
        var0.writeNullable(this.signature, MessageSignature::write);
        this.body.write(var0);
        PacketDataSerializer.writeNullable(var0, this.unsignedContent, ComponentSerialization.TRUSTED_STREAM_CODEC);
        FilterMask.write(var0, this.filterMask);
        ChatMessageType.a.STREAM_CODEC.encode(var0, this.chatType);
    }

    @Override
    public PacketType<ClientboundPlayerChatPacket> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_CHAT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handlePlayerChat(this);
    }

    @Override
    public boolean isSkippable() {
        return true;
    }
}

