/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.BitSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jspecify.annotations.Nullable;

public class ClientboundLevelChunkWithLightPacket
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundLevelChunkWithLightPacket> STREAM_CODEC = Packet.codec(ClientboundLevelChunkWithLightPacket::write, ClientboundLevelChunkWithLightPacket::new);
    private final int x;
    private final int z;
    private final ClientboundLevelChunkPacketData chunkData;
    private final ClientboundLightUpdatePacketData lightData;

    public ClientboundLevelChunkWithLightPacket(Chunk var0, LevelLightEngine var1, @Nullable BitSet var2, @Nullable BitSet var3) {
        ChunkCoordIntPair var4 = var0.getPos();
        this.x = var4.x;
        this.z = var4.z;
        this.chunkData = new ClientboundLevelChunkPacketData(var0);
        this.lightData = new ClientboundLightUpdatePacketData(var4, var1, var2, var3);
    }

    private ClientboundLevelChunkWithLightPacket(RegistryFriendlyByteBuf var0) {
        this.x = var0.readInt();
        this.z = var0.readInt();
        this.chunkData = new ClientboundLevelChunkPacketData(var0, this.x, this.z);
        this.lightData = new ClientboundLightUpdatePacketData(var0, this.x, this.z);
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeInt(this.x);
        var0.writeInt(this.z);
        this.chunkData.write(var0);
        this.lightData.write(var0);
    }

    @Override
    public PacketType<ClientboundLevelChunkWithLightPacket> type() {
        return GamePacketTypes.CLIENTBOUND_LEVEL_CHUNK_WITH_LIGHT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleLevelChunkWithLight(this);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public ClientboundLevelChunkPacketData getChunkData() {
        return this.chunkData;
    }

    public ClientboundLightUpdatePacketData getLightData() {
        return this.lightData;
    }
}

