/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.EnumChatFormat;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.FormattedString;
import org.jspecify.annotations.Nullable;

public final class IChatMutableComponent
implements IChatBaseComponent {
    private final ComponentContents contents;
    private final List<IChatBaseComponent> siblings;
    private ChatModifier style;
    private FormattedString visualOrderText = FormattedString.EMPTY;
    private @Nullable LocaleLanguage decomposedWith;

    IChatMutableComponent(ComponentContents var0, List<IChatBaseComponent> var1, ChatModifier var2) {
        this.contents = var0;
        this.siblings = var1;
        this.style = var2;
    }

    public static IChatMutableComponent create(ComponentContents var0) {
        return new IChatMutableComponent(var0, Lists.newArrayList(), ChatModifier.EMPTY);
    }

    @Override
    public ComponentContents getContents() {
        return this.contents;
    }

    @Override
    public List<IChatBaseComponent> getSiblings() {
        return this.siblings;
    }

    public IChatMutableComponent setStyle(ChatModifier var0) {
        this.style = var0;
        return this;
    }

    @Override
    public ChatModifier getStyle() {
        return this.style;
    }

    public IChatMutableComponent append(String var0) {
        if (var0.isEmpty()) {
            return this;
        }
        return this.append(IChatBaseComponent.literal(var0));
    }

    public IChatMutableComponent append(IChatBaseComponent var0) {
        this.siblings.add(var0);
        return this;
    }

    public IChatMutableComponent withStyle(UnaryOperator<ChatModifier> var0) {
        this.setStyle((ChatModifier)var0.apply(this.getStyle()));
        return this;
    }

    public IChatMutableComponent withStyle(ChatModifier var0) {
        this.setStyle(var0.applyTo(this.getStyle()));
        return this;
    }

    public IChatMutableComponent withStyle(EnumChatFormat ... var0) {
        this.setStyle(this.getStyle().applyFormats(var0));
        return this;
    }

    public IChatMutableComponent withStyle(EnumChatFormat var0) {
        this.setStyle(this.getStyle().applyFormat(var0));
        return this;
    }

    public IChatMutableComponent withColor(int var0) {
        this.setStyle(this.getStyle().withColor(var0));
        return this;
    }

    public IChatMutableComponent withoutShadow() {
        this.setStyle(this.getStyle().withoutShadow());
        return this;
    }

    @Override
    public FormattedString getVisualOrderText() {
        LocaleLanguage var0 = LocaleLanguage.getInstance();
        if (this.decomposedWith != var0) {
            this.visualOrderText = var0.getVisualOrder(this);
            this.decomposedWith = var0;
        }
        return this.visualOrderText;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof IChatMutableComponent)) return false;
        IChatMutableComponent var1 = (IChatMutableComponent)var0;
        if (!this.contents.equals(var1.contents)) return false;
        if (!this.style.equals(var1.style)) return false;
        if (!this.siblings.equals(var1.siblings)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = 1;
        var0 = 31 * var0 + this.contents.hashCode();
        var0 = 31 * var0 + this.style.hashCode();
        var0 = 31 * var0 + this.siblings.hashCode();
        return var0;
    }

    public String toString() {
        boolean var2;
        StringBuilder var0 = new StringBuilder(this.contents.toString());
        boolean var1 = !this.style.isEmpty();
        boolean bl = var2 = !this.siblings.isEmpty();
        if (var1 || var2) {
            var0.append('[');
            if (var1) {
                var0.append("style=");
                var0.append(this.style);
            }
            if (var1 && var2) {
                var0.append(", ");
            }
            if (var2) {
                var0.append("siblings=");
                var0.append(this.siblings);
            }
            var0.append(']');
        }
        return var0.toString();
    }
}

