/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import org.jspecify.annotations.Nullable;

public final class ChatHexColor {
    private static final String CUSTOM_COLOR_PREFIX = "#";
    public static final Codec<ChatHexColor> CODEC = Codec.STRING.comapFlatMap(ChatHexColor::parseColor, ChatHexColor::serialize);
    private static final Map<EnumChatFormat, ChatHexColor> LEGACY_FORMAT_TO_COLOR = (Map)Stream.of(EnumChatFormat.values()).filter(EnumChatFormat::isColor).collect(ImmutableMap.toImmutableMap(Function.identity(), var0 -> new ChatHexColor(var0.getColor(), var0.getName())));
    private static final Map<String, ChatHexColor> NAMED_COLORS = (Map)LEGACY_FORMAT_TO_COLOR.values().stream().collect(ImmutableMap.toImmutableMap(var0 -> var0.name, Function.identity()));
    private final int value;
    public final @Nullable String name;

    private ChatHexColor(int var0, String var1) {
        this.value = var0 & 0xFFFFFF;
        this.name = var1;
    }

    private ChatHexColor(int var0) {
        this.value = var0 & 0xFFFFFF;
        this.name = null;
    }

    public int getValue() {
        return this.value;
    }

    public String serialize() {
        return this.name != null ? this.name : this.formatValue();
    }

    private String formatValue() {
        return String.format(Locale.ROOT, "#%06X", this.value);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        ChatHexColor var1 = (ChatHexColor)var0;
        return this.value == var1.value;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }

    public String toString() {
        return this.serialize();
    }

    public static @Nullable ChatHexColor fromLegacyFormat(EnumChatFormat var0) {
        return LEGACY_FORMAT_TO_COLOR.get(var0);
    }

    public static ChatHexColor fromRgb(int var0) {
        return new ChatHexColor(var0);
    }

    public static DataResult<ChatHexColor> parseColor(String var0) {
        if (var0.startsWith(CUSTOM_COLOR_PREFIX)) {
            try {
                int var1 = Integer.parseInt(var0.substring(1), 16);
                if (var1 < 0 || var1 > 0xFFFFFF) {
                    return DataResult.error(() -> "Color value out of range: " + var0);
                }
                return DataResult.success((Object)ChatHexColor.fromRgb(var1), (Lifecycle)Lifecycle.stable());
            }
            catch (NumberFormatException var1) {
                return DataResult.error(() -> "Invalid color value: " + var0);
            }
        }
        ChatHexColor var1 = NAMED_COLORS.get(var0);
        if (var1 == null) {
            return DataResult.error(() -> "Invalid color name: " + var0);
        }
        return DataResult.success((Object)var1, (Lifecycle)Lifecycle.stable());
    }
}

