/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class NBTTagCompound
implements NBTBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<NBTTagCompound> CODEC = Codec.PASSTHROUGH.comapFlatMap(var0 -> {
        NBTBase var1 = (NBTBase)var0.convert((DynamicOps)DynamicOpsNBT.INSTANCE).getValue();
        if (var1 instanceof NBTTagCompound) {
            NBTTagCompound var2 = (NBTTagCompound)var1;
            return DataResult.success((Object)(var2 == var0.getValue() ? var2.copy() : var2));
        }
        return DataResult.error(() -> "Not a compound tag: " + String.valueOf(var1));
    }, var0 -> new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0.copy()));
    private static final int SELF_SIZE_IN_BYTES = 48;
    private static final int MAP_ENTRY_SIZE_IN_BYTES = 32;
    public static final NBTTagType<NBTTagCompound> TYPE = new NBTTagType.b<NBTTagCompound>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NBTTagCompound load(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.pushDepth();
            try {
                NBTTagCompound nBTTagCompound = 1.loadCompound(var0, var1);
                return nBTTagCompound;
            }
            finally {
                var1.popDepth();
            }
        }

        private static NBTTagCompound loadCompound(DataInput var0, NBTReadLimiter var1) throws IOException {
            byte var3;
            var1.accountBytes(48L);
            HashMap var2 = Maps.newHashMap();
            while ((var3 = var0.readByte()) != 0) {
                NBTBase var5;
                String var4 = 1.readString(var0, var1);
                if (var2.put(var4, var5 = NBTTagCompound.readNamedTagData(NBTTagTypes.getType(var3), var4, var0, var1)) != null) continue;
                var1.accountBytes(36L);
            }
            return new NBTTagCompound(var2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            var2.pushDepth();
            try {
                StreamTagVisitor.b b2 = 1.parseCompound(var0, var1, var2);
                return b2;
            }
            finally {
                var2.popDepth();
            }
        }

        private static StreamTagVisitor.b parseCompound(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            byte var3;
            var2.accountBytes(48L);
            block13: while ((var3 = var0.readByte()) != 0) {
                NBTTagType<?> var4 = NBTTagTypes.getType(var3);
                switch (var1.visitEntry(var4)) {
                    case HALT: {
                        return StreamTagVisitor.b.HALT;
                    }
                    case BREAK: {
                        NBTTagString.skipString(var0);
                        var4.skip(var0, var2);
                        break block13;
                    }
                    case SKIP: {
                        NBTTagString.skipString(var0);
                        var4.skip(var0, var2);
                        continue block13;
                    }
                    default: {
                        String var5 = 1.readString(var0, var2);
                        switch (var1.visitEntry(var4, var5)) {
                            case HALT: {
                                return StreamTagVisitor.b.HALT;
                            }
                            case BREAK: {
                                var4.skip(var0, var2);
                                break block13;
                            }
                            case SKIP: {
                                var4.skip(var0, var2);
                                continue block13;
                            }
                        }
                        var2.accountBytes(36L);
                        switch (var4.parse(var0, var1, var2)) {
                            case HALT: {
                                return StreamTagVisitor.b.HALT;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (var3 != 0) {
                while ((var3 = var0.readByte()) != 0) {
                    NBTTagString.skipString(var0);
                    NBTTagTypes.getType(var3).skip(var0, var2);
                }
            }
            return var1.visitContainerEnd();
        }

        private static String readString(DataInput var0, NBTReadLimiter var1) throws IOException {
            String var2 = var0.readUTF();
            var1.accountBytes(28L);
            var1.accountBytes(2L, var2.length());
            return var2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.pushDepth();
            try {
                byte var2;
                while ((var2 = var0.readByte()) != 0) {
                    NBTTagString.skipString(var0);
                    NBTTagTypes.getType(var2).skip(var0, var1);
                }
            }
            finally {
                var1.popDepth();
            }
        }

        @Override
        public String getName() {
            return "COMPOUND";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Compound";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };
    private final Map<String, NBTBase> tags;

    NBTTagCompound(Map<String, NBTBase> var0) {
        this.tags = var0;
    }

    public NBTTagCompound() {
        this(new HashMap<String, NBTBase>());
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        for (String var2 : this.tags.keySet()) {
            NBTBase var3 = this.tags.get(var2);
            NBTTagCompound.writeNamedTag(var2, var3, var0);
        }
        var0.writeByte(0);
    }

    @Override
    public int sizeInBytes() {
        int var0 = 48;
        for (Map.Entry<String, NBTBase> var2 : this.tags.entrySet()) {
            var0 += 28 + 2 * var2.getKey().length();
            var0 += 36;
            var0 += var2.getValue().sizeInBytes();
        }
        return var0;
    }

    public Set<String> keySet() {
        return this.tags.keySet();
    }

    public Set<Map.Entry<String, NBTBase>> entrySet() {
        return this.tags.entrySet();
    }

    public Collection<NBTBase> values() {
        return this.tags.values();
    }

    public void forEach(BiConsumer<String, NBTBase> var0) {
        this.tags.forEach(var0);
    }

    @Override
    public byte getId() {
        return 10;
    }

    public NBTTagType<NBTTagCompound> getType() {
        return TYPE;
    }

    public int size() {
        return this.tags.size();
    }

    public @Nullable NBTBase put(String var0, NBTBase var1) {
        return this.tags.put(var0, var1);
    }

    public void putByte(String var0, byte var1) {
        this.tags.put(var0, NBTTagByte.valueOf(var1));
    }

    public void putShort(String var0, short var1) {
        this.tags.put(var0, NBTTagShort.valueOf(var1));
    }

    public void putInt(String var0, int var1) {
        this.tags.put(var0, NBTTagInt.valueOf(var1));
    }

    public void putLong(String var0, long var1) {
        this.tags.put(var0, NBTTagLong.valueOf(var1));
    }

    public void putFloat(String var0, float var1) {
        this.tags.put(var0, NBTTagFloat.valueOf(var1));
    }

    public void putDouble(String var0, double var1) {
        this.tags.put(var0, NBTTagDouble.valueOf(var1));
    }

    public void putString(String var0, String var1) {
        this.tags.put(var0, NBTTagString.valueOf(var1));
    }

    public void putByteArray(String var0, byte[] var1) {
        this.tags.put(var0, new NBTTagByteArray(var1));
    }

    public void putIntArray(String var0, int[] var1) {
        this.tags.put(var0, new NBTTagIntArray(var1));
    }

    public void putLongArray(String var0, long[] var1) {
        this.tags.put(var0, new NBTTagLongArray(var1));
    }

    public void putBoolean(String var0, boolean var1) {
        this.tags.put(var0, NBTTagByte.valueOf(var1));
    }

    public @Nullable NBTBase get(String var0) {
        return this.tags.get(var0);
    }

    public boolean contains(String var0) {
        return this.tags.containsKey(var0);
    }

    private Optional<NBTBase> getOptional(String var0) {
        return Optional.ofNullable(this.tags.get(var0));
    }

    public Optional<Byte> getByte(String var0) {
        return this.getOptional(var0).flatMap(NBTBase::asByte);
    }

    public byte getByteOr(String var0, byte var1) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.byteValue();
        }
        return var1;
    }

    public Optional<Short> getShort(String var0) {
        return this.getOptional(var0).flatMap(NBTBase::asShort);
    }

    public short getShortOr(String var0, short var1) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.shortValue();
        }
        return var1;
    }

    public Optional<Integer> getInt(String var0) {
        return this.getOptional(var0).flatMap(NBTBase::asInt);
    }

    public int getIntOr(String var0, int var1) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.intValue();
        }
        return var1;
    }

    public Optional<Long> getLong(String var0) {
        return this.getOptional(var0).flatMap(NBTBase::asLong);
    }

    public long getLongOr(String var0, long var1) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var3 = (NBTNumber)nBTBase;
            return var3.longValue();
        }
        return var1;
    }

    public Optional<Float> getFloat(String var0) {
        return this.getOptional(var0).flatMap(NBTBase::asFloat);
    }

    public float getFloatOr(String var0, float var1) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.floatValue();
        }
        return var1;
    }

    public Optional<Double> getDouble(String var0) {
        return this.getOptional(var0).flatMap(NBTBase::asDouble);
    }

    public double getDoubleOr(String var0, double var1) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var3 = (NBTNumber)nBTBase;
            return var3.doubleValue();
        }
        return var1;
    }

    public Optional<String> getString(String var0) {
        return this.getOptional(var0).flatMap(NBTBase::asString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getStringOr(String var0, String var1) {
        NBTBase nBTBase = this.tags.get(var0);
        if (!(nBTBase instanceof NBTTagString)) return var1;
        NBTTagString nBTTagString = (NBTTagString)nBTBase;
        try {
            String string = nBTTagString.value();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public Optional<byte[]> getByteArray(String var0) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTTagByteArray) {
            NBTTagByteArray var1 = (NBTTagByteArray)nBTBase;
            return Optional.of(var1.getAsByteArray());
        }
        return Optional.empty();
    }

    public Optional<int[]> getIntArray(String var0) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTTagIntArray) {
            NBTTagIntArray var1 = (NBTTagIntArray)nBTBase;
            return Optional.of(var1.getAsIntArray());
        }
        return Optional.empty();
    }

    public Optional<long[]> getLongArray(String var0) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTTagLongArray) {
            NBTTagLongArray var1 = (NBTTagLongArray)nBTBase;
            return Optional.of(var1.getAsLongArray());
        }
        return Optional.empty();
    }

    public Optional<NBTTagCompound> getCompound(String var0) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTTagCompound) {
            NBTTagCompound var1 = (NBTTagCompound)nBTBase;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public NBTTagCompound getCompoundOrEmpty(String var0) {
        return this.getCompound(var0).orElseGet(NBTTagCompound::new);
    }

    public Optional<NBTTagList> getList(String var0) {
        NBTBase nBTBase = this.tags.get(var0);
        if (nBTBase instanceof NBTTagList) {
            NBTTagList var1 = (NBTTagList)nBTBase;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public NBTTagList getListOrEmpty(String var0) {
        return this.getList(var0).orElseGet(NBTTagList::new);
    }

    public Optional<Boolean> getBoolean(String var0) {
        return this.getOptional(var0).flatMap(NBTBase::asBoolean);
    }

    public boolean getBooleanOr(String var0, boolean var1) {
        return this.getByteOr(var0, var1 ? (byte)1 : 0) != 0;
    }

    public @Nullable NBTBase remove(String var0) {
        return this.tags.remove(var0);
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitCompound(this);
        return var0.build();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    protected NBTTagCompound shallowCopy() {
        return new NBTTagCompound(new HashMap<String, NBTBase>(this.tags));
    }

    @Override
    public NBTTagCompound copy() {
        HashMap<String, NBTBase> var0 = new HashMap<String, NBTBase>();
        this.tags.forEach((? super K var1, ? super V var2) -> var0.put((String)var1, var2.copy()));
        return new NBTTagCompound(var0);
    }

    @Override
    public Optional<NBTTagCompound> asCompound() {
        return Optional.of(this);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagCompound && Objects.equals(this.tags, ((NBTTagCompound)var0).tags);
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    private static void writeNamedTag(String var0, NBTBase var1, DataOutput var2) throws IOException {
        var2.writeByte(var1.getId());
        if (var1.getId() == 0) {
            return;
        }
        var2.writeUTF(var0);
        var1.write(var2);
    }

    static NBTBase readNamedTagData(NBTTagType<?> var0, String var1, DataInput var2, NBTReadLimiter var3) {
        try {
            return var0.load(var2, var3);
        }
        catch (IOException var4) {
            CrashReport var5 = CrashReport.forThrowable(var4, "Loading NBT data");
            CrashReportSystemDetails var6 = var5.addCategory("NBT Tag");
            var6.setDetail("Tag name", var1);
            var6.setDetail("Tag type", var0.getName());
            throw new ReportedNbtException(var5);
        }
    }

    public NBTTagCompound merge(NBTTagCompound var0) {
        for (String var2 : var0.tags.keySet()) {
            NBTBase var3 = var0.tags.get(var2);
            if (var3 instanceof NBTTagCompound) {
                NBTTagCompound var4 = (NBTTagCompound)var3;
                NBTBase nBTBase = this.tags.get(var2);
                if (nBTBase instanceof NBTTagCompound) {
                    NBTTagCompound var5 = (NBTTagCompound)nBTBase;
                    var5.merge(var4);
                    continue;
                }
            }
            this.put(var2, var3.copy());
        }
        return this;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitCompound(this);
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        block14: for (Map.Entry<String, NBTBase> var2 : this.tags.entrySet()) {
            NBTBase var3 = var2.getValue();
            NBTTagType<?> var4 = var3.getType();
            StreamTagVisitor.a var5 = var0.visitEntry(var4);
            switch (var5) {
                case HALT: {
                    return StreamTagVisitor.b.HALT;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            var5 = var0.visitEntry(var4, var2.getKey());
            switch (var5) {
                case HALT: {
                    return StreamTagVisitor.b.HALT;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            StreamTagVisitor.b var6 = var3.accept(var0);
            switch (var6) {
                case HALT: {
                    return StreamTagVisitor.b.HALT;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
            }
        }
        return var0.visitContainerEnd();
    }

    public <T> void store(String var0, Codec<T> var1, T var2) {
        this.store(var0, var1, DynamicOpsNBT.INSTANCE, var2);
    }

    public <T> void storeNullable(String var0, Codec<T> var1, @Nullable T var2) {
        if (var2 != null) {
            this.store(var0, var1, var2);
        }
    }

    public <T> void store(String var0, Codec<T> var1, DynamicOps<NBTBase> var2, T var3) {
        this.put(var0, (NBTBase)var1.encodeStart(var2, var3).getOrThrow());
    }

    public <T> void storeNullable(String var0, Codec<T> var1, DynamicOps<NBTBase> var2, @Nullable T var3) {
        if (var3 != null) {
            this.store(var0, var1, var2, var3);
        }
    }

    public <T> void store(MapCodec<T> var0, T var1) {
        this.store(var0, DynamicOpsNBT.INSTANCE, var1);
    }

    public <T> void store(MapCodec<T> var0, DynamicOps<NBTBase> var1, T var2) {
        this.merge((NBTTagCompound)var0.encoder().encodeStart(var1, var2).getOrThrow());
    }

    public <T> Optional<T> read(String var0, Codec<T> var1) {
        return this.read(var0, var1, DynamicOpsNBT.INSTANCE);
    }

    public <T> Optional<T> read(String var0, Codec<T> var1, DynamicOps<NBTBase> var22) {
        NBTBase var3 = this.get(var0);
        if (var3 == null) {
            return Optional.empty();
        }
        return var1.parse(var22, (Object)var3).resultOrPartial(var2 -> LOGGER.error("Failed to read field ({}={}): {}", new Object[]{var0, var3, var2}));
    }

    public <T> Optional<T> read(MapCodec<T> var0) {
        return this.read(var0, DynamicOpsNBT.INSTANCE);
    }

    public <T> Optional<T> read(MapCodec<T> var02, DynamicOps<NBTBase> var1) {
        return var02.decode(var1, (MapLike)var1.getMap((Object)this).getOrThrow()).resultOrPartial(var0 -> LOGGER.error("Failed to read value ({}): {}", (Object)this, var0));
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

