/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestException;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessHelper;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.gametest.framework.GameTestHarnessTimeout;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.UnknownGameTestException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.ticks.TickListServer;
import org.jspecify.annotations.Nullable;

public class GameTestHarnessInfo {
    private final Holder.c<GameTestInstance> test;
    private @Nullable BlockPosition testBlockPos;
    private final WorldServer level;
    private final Collection<GameTestHarnessListener> listeners = Lists.newArrayList();
    private final int timeoutTicks;
    private final Collection<GameTestHarnessSequence> sequences = Lists.newCopyOnWriteArrayList();
    private final Object2LongMap<Runnable> runAtTickTimeMap = new Object2LongOpenHashMap();
    private boolean placedStructure;
    private boolean chunksLoaded;
    private int tickCount;
    private boolean started;
    private final RetryOptions retryOptions;
    private final Stopwatch timer = Stopwatch.createUnstarted();
    private boolean done;
    private final EnumBlockRotation extraRotation;
    private @Nullable GameTestException error;
    private @Nullable TestInstanceBlockEntity testInstanceBlockEntity;

    public GameTestHarnessInfo(Holder.c<GameTestInstance> var0, EnumBlockRotation var1, WorldServer var2, RetryOptions var3) {
        this.test = var0;
        this.level = var2;
        this.retryOptions = var3;
        this.timeoutTicks = var0.value().maxTicks();
        this.extraRotation = var1;
    }

    public void setTestBlockPos(@Nullable BlockPosition var0) {
        this.testBlockPos = var0;
    }

    public GameTestHarnessInfo startExecution(int var0) {
        this.tickCount = -(this.test.value().setupTicks() + var0 + 1);
        return this;
    }

    public void placeStructure() {
        if (this.placedStructure) {
            return;
        }
        TestInstanceBlockEntity var02 = this.getTestInstanceBlockEntity();
        if (!var02.placeStructure()) {
            this.fail(IChatBaseComponent.translatable("test.error.structure.failure", var02.getTestName().getString()));
        }
        this.placedStructure = true;
        var02.encaseStructure();
        StructureBoundingBox var1 = var02.getStructureBoundingBox();
        ((TickListServer)this.level.getBlockTicks()).clearArea(var1);
        this.level.clearBlockEvents(var1);
        this.listeners.forEach(var0 -> var0.testStructureLoaded(this));
    }

    public void tick(GameTestHarnessRunner var0) {
        if (this.isDone()) {
            return;
        }
        if (!this.placedStructure) {
            this.fail(IChatBaseComponent.translatable("test.error.ticking_without_structure"));
        }
        if (this.testInstanceBlockEntity == null) {
            this.fail(IChatBaseComponent.translatable("test.error.missing_block_entity"));
        }
        if (this.error != null) {
            this.finish();
        }
        if (!this.chunksLoaded) {
            if (!this.testInstanceBlockEntity.getStructureBoundingBox().intersectingChunks().allMatch(this.level::areEntitiesActuallyLoadedAndTicking)) {
                return;
            }
        }
        this.chunksLoaded = true;
        this.tickInternal();
        if (this.isDone()) {
            if (this.error != null) {
                this.listeners.forEach(var1 -> var1.testFailed(this, var0));
            } else {
                this.listeners.forEach(var1 -> var1.testPassed(this, var0));
            }
        }
    }

    private void tickInternal() {
        ++this.tickCount;
        if (this.tickCount < 0) {
            return;
        }
        if (!this.started) {
            this.startTest();
        }
        ObjectIterator var02 = this.runAtTickTimeMap.object2LongEntrySet().iterator();
        while (var02.hasNext()) {
            Object2LongMap.Entry var1 = (Object2LongMap.Entry)var02.next();
            if (var1.getLongValue() > (long)this.tickCount) continue;
            try {
                ((Runnable)var1.getKey()).run();
            }
            catch (GameTestException var2) {
                this.fail(var2);
            }
            catch (Exception var2) {
                this.fail(new UnknownGameTestException(var2));
            }
            var02.remove();
        }
        if (this.tickCount > this.timeoutTicks) {
            if (this.sequences.isEmpty()) {
                this.fail(new GameTestHarnessTimeout(IChatBaseComponent.translatable("test.error.timeout.no_result", this.test.value().maxTicks())));
            } else {
                this.sequences.forEach(var0 -> var0.tickAndFailIfNotComplete(this.tickCount));
                if (this.error == null) {
                    this.fail(new GameTestHarnessTimeout(IChatBaseComponent.translatable("test.error.timeout.no_sequences_finished", this.test.value().maxTicks())));
                }
            }
        } else {
            this.sequences.forEach(var0 -> var0.tickAndContinue(this.tickCount));
        }
    }

    private void startTest() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.timer.start();
        this.getTestInstanceBlockEntity().setRunning();
        try {
            this.test.value().run(new GameTestHarnessHelper(this));
        }
        catch (GameTestException var0) {
            this.fail(var0);
        }
        catch (Exception var0) {
            this.fail(new UnknownGameTestException(var0));
        }
    }

    public void setRunAtTickTime(long var0, Runnable var2) {
        this.runAtTickTimeMap.put((Object)var2, var0);
    }

    public MinecraftKey id() {
        return this.test.key().identifier();
    }

    public @Nullable BlockPosition getTestBlockPos() {
        return this.testBlockPos;
    }

    public BlockPosition getTestOrigin() {
        return this.testInstanceBlockEntity.getStartCorner();
    }

    public AxisAlignedBB getStructureBounds() {
        TestInstanceBlockEntity var0 = this.getTestInstanceBlockEntity();
        return var0.getStructureBounds();
    }

    public TestInstanceBlockEntity getTestInstanceBlockEntity() {
        if (this.testInstanceBlockEntity == null) {
            if (this.testBlockPos == null) {
                throw new IllegalStateException("This GameTestInfo has no position");
            }
            TileEntity tileEntity = this.level.getBlockEntity(this.testBlockPos);
            if (tileEntity instanceof TestInstanceBlockEntity) {
                TestInstanceBlockEntity var0;
                this.testInstanceBlockEntity = var0 = (TestInstanceBlockEntity)tileEntity;
            }
            if (this.testInstanceBlockEntity == null) {
                throw new IllegalStateException("Could not find a test instance block entity at the given coordinate " + String.valueOf(this.testBlockPos));
            }
        }
        return this.testInstanceBlockEntity;
    }

    public WorldServer getLevel() {
        return this.level;
    }

    public boolean hasSucceeded() {
        return this.done && this.error == null;
    }

    public boolean hasFailed() {
        return this.error != null;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public boolean isDone() {
        return this.done;
    }

    public long getRunTime() {
        return this.timer.elapsed(TimeUnit.MILLISECONDS);
    }

    private void finish() {
        if (!this.done) {
            this.done = true;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    public void succeed() {
        if (this.error == null) {
            this.finish();
            AxisAlignedBB var02 = this.getStructureBounds();
            List<Entity> var1 = this.getLevel().getEntitiesOfClass(Entity.class, var02.inflate(1.0), var0 -> !(var0 instanceof EntityHuman));
            var1.forEach(var0 -> var0.remove(Entity.RemovalReason.DISCARDED));
        }
    }

    public void fail(IChatBaseComponent var0) {
        this.fail(new GameTestHarnessAssertion(var0, this.tickCount));
    }

    public void fail(GameTestException var0) {
        this.error = var0;
    }

    public @Nullable GameTestException getError() {
        return this.error;
    }

    public String toString() {
        return this.id().toString();
    }

    public void addListener(GameTestHarnessListener var0) {
        this.listeners.add(var0);
    }

    public @Nullable GameTestHarnessInfo prepareTestStructure() {
        TestInstanceBlockEntity var0 = this.createTestInstanceBlock(Objects.requireNonNull(this.testBlockPos), this.extraRotation, this.level);
        if (var0 != null) {
            this.testInstanceBlockEntity = var0;
            this.placeStructure();
            return this;
        }
        return null;
    }

    private @Nullable TestInstanceBlockEntity createTestInstanceBlock(BlockPosition var0, EnumBlockRotation var1, WorldServer var2) {
        var2.setBlockAndUpdate(var0, Blocks.TEST_INSTANCE_BLOCK.defaultBlockState());
        TileEntity tileEntity = var2.getBlockEntity(var0);
        if (tileEntity instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity var3 = (TestInstanceBlockEntity)tileEntity;
            ResourceKey<GameTestInstance> var4 = this.getTestHolder().key();
            BaseBlockPosition var5 = TestInstanceBlockEntity.getStructureSize(var2, var4).orElse(new BaseBlockPosition(1, 1, 1));
            var3.set(new TestInstanceBlockEntity.a(Optional.of(var4), var5, var1, false, TestInstanceBlockEntity.c.CLEARED, Optional.empty()));
            return var3;
        }
        return null;
    }

    int getTick() {
        return this.tickCount;
    }

    GameTestHarnessSequence createSequence() {
        GameTestHarnessSequence var0 = new GameTestHarnessSequence(this);
        this.sequences.add(var0);
        return var0;
    }

    public boolean isRequired() {
        return this.test.value().required();
    }

    public boolean isOptional() {
        return !this.test.value().required();
    }

    public MinecraftKey getStructure() {
        return this.test.value().structure();
    }

    public EnumBlockRotation getRotation() {
        return this.test.value().info().rotation().getRotated(this.extraRotation);
    }

    public GameTestInstance getTest() {
        return this.test.value();
    }

    public Holder.c<GameTestInstance> getTestHolder() {
        return this.test;
    }

    public int getTimeoutTicks() {
        return this.timeoutTicks;
    }

    public boolean isFlaky() {
        return this.test.value().maxAttempts() > 1;
    }

    public int maxAttempts() {
        return this.test.value().maxAttempts();
    }

    public int requiredSuccesses() {
        return this.test.value().requiredSuccesses();
    }

    public RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public Stream<GameTestHarnessListener> getListeners() {
        return this.listeners.stream();
    }

    public GameTestHarnessInfo copyReset() {
        GameTestHarnessInfo var0 = new GameTestHarnessInfo(this.test, this.extraRotation, this.level, this.retryOptions());
        if (this.testBlockPos != null) {
            var0.setTestBlockPos(this.testBlockPos);
        }
        return var0;
    }
}

