/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.biome;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.Particles;
import net.minecraft.data.worldgen.BiomeSettings;
import net.minecraft.data.worldgen.WorldGenCarvers;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.attribute.AmbientAdditionsSettings;
import net.minecraft.world.attribute.AmbientMoodSettings;
import net.minecraft.world.attribute.AmbientParticle;
import net.minecraft.world.attribute.AmbientSounds;
import net.minecraft.world.attribute.BackgroundMusic;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class NetherBiomes {
    private static BiomeBase.a baseBiome() {
        return new BiomeBase.a().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeFog.a().waterColor(4159204).build());
    }

    public static BiomeBase netherWastes(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs var2 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.MONSTER, 50, new BiomeSettingsMobs.c(EntityTypes.GHAST, 4, 4)).addSpawn(EnumCreatureType.MONSTER, 100, new BiomeSettingsMobs.c(EntityTypes.ZOMBIFIED_PIGLIN, 4, 4)).addSpawn(EnumCreatureType.MONSTER, 2, new BiomeSettingsMobs.c(EntityTypes.MAGMA_CUBE, 4, 4)).addSpawn(EnumCreatureType.MONSTER, 1, new BiomeSettingsMobs.c(EntityTypes.ENDERMAN, 4, 4)).addSpawn(EnumCreatureType.MONSTER, 15, new BiomeSettingsMobs.c(EntityTypes.PIGLIN, 4, 4)).addSpawn(EnumCreatureType.CREATURE, 60, new BiomeSettingsMobs.c(EntityTypes.STRIDER, 1, 2)).build();
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1).addCarver(WorldGenCarvers.NETHER_CAVE).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.SPRING_LAVA);
        BiomeSettings.addDefaultMushrooms(var3);
        var3.addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_OPEN).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_FIRE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_SOUL_FIRE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE_EXTRA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, VegetationPlacements.BROWN_MUSHROOM_NETHER).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, VegetationPlacements.RED_MUSHROOM_NETHER).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_MAGMA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_CLOSED);
        BiomeSettings.addNetherDefaultOres(var3);
        return NetherBiomes.baseBiome().setAttribute(EnvironmentAttributes.FOG_COLOR, -13432824).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_NETHER_WASTES)).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, new AmbientSounds(Optional.of(SoundEffects.AMBIENT_NETHER_WASTES_LOOP), Optional.of(new AmbientMoodSettings(SoundEffects.AMBIENT_NETHER_WASTES_MOOD, 6000, 8, 2.0)), List.of(new AmbientAdditionsSettings(SoundEffects.AMBIENT_NETHER_WASTES_ADDITIONS, 0.0111)))).mobSpawnSettings(var2).generationSettings(var3.build()).build();
    }

    public static BiomeBase soulSandValley(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        double var2 = 0.7;
        double var4 = 0.15;
        BiomeSettingsMobs var6 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.MONSTER, 20, new BiomeSettingsMobs.c(EntityTypes.SKELETON, 5, 5)).addSpawn(EnumCreatureType.MONSTER, 50, new BiomeSettingsMobs.c(EntityTypes.GHAST, 4, 4)).addSpawn(EnumCreatureType.MONSTER, 1, new BiomeSettingsMobs.c(EntityTypes.ENDERMAN, 4, 4)).addSpawn(EnumCreatureType.CREATURE, 60, new BiomeSettingsMobs.c(EntityTypes.STRIDER, 1, 2)).addMobCharge(EntityTypes.SKELETON, 0.7, 0.15).addMobCharge(EntityTypes.GHAST, 0.7, 0.15).addMobCharge(EntityTypes.ENDERMAN, 0.7, 0.15).addMobCharge(EntityTypes.STRIDER, 0.7, 0.15).build();
        BiomeSettingsGeneration.a var7 = new BiomeSettingsGeneration.a(var0, var1).addCarver(WorldGenCarvers.NETHER_CAVE).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.SPRING_LAVA).addFeature(WorldGenStage.Decoration.LOCAL_MODIFICATIONS, NetherPlacements.BASALT_PILLAR).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_OPEN).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_FIRE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_SOUL_FIRE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE_EXTRA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_CRIMSON_ROOTS).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_MAGMA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_CLOSED).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_SOUL_SAND);
        BiomeSettings.addNetherDefaultOres(var7);
        return NetherBiomes.baseBiome().setAttribute(EnvironmentAttributes.FOG_COLOR, -14989499).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_SOUL_SAND_VALLEY)).setAttribute(EnvironmentAttributes.AMBIENT_PARTICLES, AmbientParticle.of(Particles.ASH, 0.00625f)).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, new AmbientSounds(Optional.of(SoundEffects.AMBIENT_SOUL_SAND_VALLEY_LOOP), Optional.of(new AmbientMoodSettings(SoundEffects.AMBIENT_SOUL_SAND_VALLEY_MOOD, 6000, 8, 2.0)), List.of(new AmbientAdditionsSettings(SoundEffects.AMBIENT_SOUL_SAND_VALLEY_ADDITIONS, 0.0111)))).mobSpawnSettings(var6).generationSettings(var7.build()).build();
    }

    public static BiomeBase basaltDeltas(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs var2 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.MONSTER, 40, new BiomeSettingsMobs.c(EntityTypes.GHAST, 1, 1)).addSpawn(EnumCreatureType.MONSTER, 100, new BiomeSettingsMobs.c(EntityTypes.MAGMA_CUBE, 2, 5)).addSpawn(EnumCreatureType.CREATURE, 60, new BiomeSettingsMobs.c(EntityTypes.STRIDER, 1, 2)).build();
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1).addCarver(WorldGenCarvers.NETHER_CAVE).addFeature(WorldGenStage.Decoration.SURFACE_STRUCTURES, NetherPlacements.DELTA).addFeature(WorldGenStage.Decoration.SURFACE_STRUCTURES, NetherPlacements.SMALL_BASALT_COLUMNS).addFeature(WorldGenStage.Decoration.SURFACE_STRUCTURES, NetherPlacements.LARGE_BASALT_COLUMNS).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.BASALT_BLOBS).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.BLACKSTONE_BLOBS).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_DELTA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_FIRE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_SOUL_FIRE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE_EXTRA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, VegetationPlacements.BROWN_MUSHROOM_NETHER).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, VegetationPlacements.RED_MUSHROOM_NETHER).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_MAGMA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_CLOSED_DOUBLE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_GOLD_DELTAS).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_QUARTZ_DELTAS);
        BiomeSettings.addAncientDebris(var3);
        return NetherBiomes.baseBiome().setAttribute(EnvironmentAttributes.FOG_COLOR, -9937040).setAttribute(EnvironmentAttributes.AMBIENT_PARTICLES, AmbientParticle.of(Particles.WHITE_ASH, 0.118093334f)).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_BASALT_DELTAS)).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, new AmbientSounds(Optional.of(SoundEffects.AMBIENT_BASALT_DELTAS_LOOP), Optional.of(new AmbientMoodSettings(SoundEffects.AMBIENT_BASALT_DELTAS_MOOD, 6000, 8, 2.0)), List.of(new AmbientAdditionsSettings(SoundEffects.AMBIENT_BASALT_DELTAS_ADDITIONS, 0.0111)))).mobSpawnSettings(var2).generationSettings(var3.build()).build();
    }

    public static BiomeBase crimsonForest(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs var2 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.MONSTER, 1, new BiomeSettingsMobs.c(EntityTypes.ZOMBIFIED_PIGLIN, 2, 4)).addSpawn(EnumCreatureType.MONSTER, 9, new BiomeSettingsMobs.c(EntityTypes.HOGLIN, 3, 4)).addSpawn(EnumCreatureType.MONSTER, 5, new BiomeSettingsMobs.c(EntityTypes.PIGLIN, 3, 4)).addSpawn(EnumCreatureType.CREATURE, 60, new BiomeSettingsMobs.c(EntityTypes.STRIDER, 1, 2)).build();
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1).addCarver(WorldGenCarvers.NETHER_CAVE).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.SPRING_LAVA);
        BiomeSettings.addDefaultMushrooms(var3);
        var3.addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_OPEN).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_FIRE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE_EXTRA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_MAGMA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_CLOSED).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, NetherPlacements.WEEPING_VINES).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, TreePlacements.CRIMSON_FUNGI).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, NetherPlacements.CRIMSON_FOREST_VEGETATION);
        BiomeSettings.addNetherDefaultOres(var3);
        return NetherBiomes.baseBiome().setAttribute(EnvironmentAttributes.FOG_COLOR, -13434109).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_CRIMSON_FOREST)).setAttribute(EnvironmentAttributes.AMBIENT_PARTICLES, AmbientParticle.of(Particles.CRIMSON_SPORE, 0.025f)).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, new AmbientSounds(Optional.of(SoundEffects.AMBIENT_CRIMSON_FOREST_LOOP), Optional.of(new AmbientMoodSettings(SoundEffects.AMBIENT_CRIMSON_FOREST_MOOD, 6000, 8, 2.0)), List.of(new AmbientAdditionsSettings(SoundEffects.AMBIENT_CRIMSON_FOREST_ADDITIONS, 0.0111)))).mobSpawnSettings(var2).generationSettings(var3.build()).build();
    }

    public static BiomeBase warpedForest(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
        BiomeSettingsMobs var2 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.MONSTER, 1, new BiomeSettingsMobs.c(EntityTypes.ENDERMAN, 4, 4)).addSpawn(EnumCreatureType.CREATURE, 60, new BiomeSettingsMobs.c(EntityTypes.STRIDER, 1, 2)).addMobCharge(EntityTypes.ENDERMAN, 1.0, 0.12).build();
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a(var0, var1).addCarver(WorldGenCarvers.NETHER_CAVE).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.SPRING_LAVA);
        BiomeSettings.addDefaultMushrooms(var3);
        var3.addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_OPEN).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_FIRE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_SOUL_FIRE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE_EXTRA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_MAGMA).addFeature(WorldGenStage.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_CLOSED).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, TreePlacements.WARPED_FUNGI).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, NetherPlacements.WARPED_FOREST_VEGETATION).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, NetherPlacements.NETHER_SPROUTS).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, NetherPlacements.TWISTING_VINES);
        BiomeSettings.addNetherDefaultOres(var3);
        return NetherBiomes.baseBiome().setAttribute(EnvironmentAttributes.FOG_COLOR, -15071974).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, new BackgroundMusic(SoundEffects.MUSIC_BIOME_WARPED_FOREST)).setAttribute(EnvironmentAttributes.AMBIENT_PARTICLES, AmbientParticle.of(Particles.WARPED_SPORE, 0.01428f)).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, new AmbientSounds(Optional.of(SoundEffects.AMBIENT_WARPED_FOREST_LOOP), Optional.of(new AmbientMoodSettings(SoundEffects.AMBIENT_WARPED_FOREST_MOOD, 6000, 8, 2.0)), List.of(new AmbientAdditionsSettings(SoundEffects.AMBIENT_WARPED_FOREST_ADDITIONS, 0.0111)))).mobSpawnSettings(var2).generationSettings(var3.build()).build();
    }
}

