/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.SystemUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class DebugReportNBT
implements DebugReportProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Iterable<Path> inputFolders;
    private final PackOutput output;

    public DebugReportNBT(PackOutput var0, Collection<Path> var1) {
        this.inputFolders = var1;
        this.output = var0;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput var02) {
        Path var1 = this.output.getOutputFolder();
        ArrayList<CompletionStage> var2 = new ArrayList<CompletionStage>();
        for (Path var4 : this.inputFolders) {
            var2.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> var32 = Files.walk(var4, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])var32.filter(var0 -> var0.toString().endsWith(".nbt")).map(var3 -> CompletableFuture.runAsync(() -> DebugReportNBT.convertStructure(var02, var3, DebugReportNBT.getName(var4, var3), var1), SystemUtils.ioPool())).toArray(CompletableFuture[]::new));
                        if (var32 == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (var32 != null) {
                                try {
                                    var32.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException var33) {
                            LOGGER.error("Failed to read structure input directory", (Throwable)var33);
                            return CompletableFuture.completedFuture(null);
                        }
                    }
                    var32.close();
                }
                return completableFuture;
            }, SystemUtils.backgroundExecutor().forName("NbtToSnbt")).thenCompose(var0 -> var0));
        }
        return CompletableFuture.allOf((CompletableFuture[])var2.toArray(CompletableFuture[]::new));
    }

    @Override
    public final String getName() {
        return "NBT -> SNBT";
    }

    private static String getName(Path var0, Path var1) {
        String var2 = var0.relativize(var1).toString().replaceAll("\\\\", "/");
        return var2.substring(0, var2.length() - ".nbt".length());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static @Nullable Path convertStructure(CachedOutput var0, Path var1, String var2, Path var3) {
        try (InputStream var4 = Files.newInputStream(var1, new OpenOption[0]);){
            Path path;
            try (FastBufferedInputStream var5 = new FastBufferedInputStream(var4);){
                Path var6 = var3.resolve(var2 + ".snbt");
                DebugReportNBT.writeSnbt(var0, var6, GameProfileSerializer.structureToSnbt(NBTCompressedStreamTools.readCompressed(var5, NBTReadLimiter.unlimitedHeap())));
                LOGGER.info("Converted {} from NBT to SNBT", (Object)var2);
                path = var6;
            }
            return path;
        }
        catch (IOException var42) {
            LOGGER.error("Couldn't convert {} from NBT to SNBT at {}", new Object[]{var2, var1, var42});
            return null;
        }
    }

    public static void writeSnbt(CachedOutput var0, Path var1, String var2) throws IOException {
        ByteArrayOutputStream var3 = new ByteArrayOutputStream();
        HashingOutputStream var4 = new HashingOutputStream(Hashing.sha1(), (OutputStream)var3);
        var4.write(var2.getBytes(StandardCharsets.UTF_8));
        var4.write(10);
        var0.writeIfNeeded(var1, var3.toByteArray(), var4.hash());
    }
}

