/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.Vec3D;

public class MinecartDispenseItemBehavior
extends DispenseBehaviorItem {
    private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();
    private final EntityTypes<? extends EntityMinecartAbstract> entityType;

    public MinecartDispenseItemBehavior(EntityTypes<? extends EntityMinecartAbstract> var0) {
        this.entityType = var0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ItemStack execute(SourceBlock var0, ItemStack var1) {
        Object var15;
        double var13;
        EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
        WorldServer var3 = var0.level();
        Vec3D var4 = var0.center();
        double var5 = var4.x() + (double)var2.getStepX() * 1.125;
        double var7 = Math.floor(var4.y()) + (double)var2.getStepY();
        double var9 = var4.z() + (double)var2.getStepZ() * 1.125;
        BlockPosition var11 = var0.pos().relative(var2);
        IBlockData var12 = var3.getBlockState(var11);
        if (var12.is(TagsBlock.RAILS)) {
            var13 = MinecartDispenseItemBehavior.getRailShape(var12).isSlope() ? 0.6 : 0.1;
        } else {
            if (!var12.isAir()) return this.defaultDispenseItemBehavior.dispense(var0, var1);
            var15 = var3.getBlockState(var11.below());
            if (!((BlockBase.BlockData)var15).is(TagsBlock.RAILS)) return this.defaultDispenseItemBehavior.dispense(var0, var1);
            var13 = var2 == EnumDirection.DOWN || !MinecartDispenseItemBehavior.getRailShape((IBlockData)var15).isSlope() ? -0.9 : -0.4;
        }
        var15 = new Vec3D(var5, var7 + var13, var9);
        EntityMinecartAbstract var16 = EntityMinecartAbstract.createMinecart(var3, ((Vec3D)var15).x, ((Vec3D)var15).y, ((Vec3D)var15).z, this.entityType, EntitySpawnReason.DISPENSER, var1, null);
        if (var16 == null) return var1;
        var3.addFreshEntity(var16);
        var1.shrink(1);
        return var1;
    }

    private static BlockPropertyTrackPosition getRailShape(IBlockData var0) {
        BlockPropertyTrackPosition blockPropertyTrackPosition;
        Block block = var0.getBlock();
        if (block instanceof BlockMinecartTrackAbstract) {
            BlockMinecartTrackAbstract var1 = (BlockMinecartTrackAbstract)block;
            blockPropertyTrackPosition = var0.getValue(var1.getShapeProperty());
        } else {
            blockPropertyTrackPosition = BlockPropertyTrackPosition.NORTH_SOUTH;
        }
        return blockPropertyTrackPosition;
    }

    @Override
    protected void playSound(SourceBlock var0) {
        var0.level().levelEvent(1000, var0.pos(), 0);
    }
}

