/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.Vec3D;

public class DispenseBehaviorBoat
extends DispenseBehaviorItem {
    private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();
    private final EntityTypes<? extends AbstractBoat> type;

    public DispenseBehaviorBoat(EntityTypes<? extends AbstractBoat> var0) {
        this.type = var0;
    }

    @Override
    public ItemStack execute(SourceBlock var0, ItemStack var1) {
        double var14;
        EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
        WorldServer var3 = var0.level();
        Vec3D var4 = var0.center();
        double var5 = 0.5625 + (double)this.type.getWidth() / 2.0;
        double var7 = var4.x() + (double)var2.getStepX() * var5;
        double var9 = var4.y() + (double)((float)var2.getStepY() * 1.125f);
        double var11 = var4.z() + (double)var2.getStepZ() * var5;
        BlockPosition var13 = var0.pos().relative(var2);
        if (var3.getFluidState(var13).is(TagsFluid.WATER)) {
            var14 = 1.0;
        } else if (var3.getBlockState(var13).isAir() && var3.getFluidState(var13.below()).is(TagsFluid.WATER)) {
            var14 = 0.0;
        } else {
            return this.defaultDispenseItemBehavior.dispense(var0, var1);
        }
        AbstractBoat var16 = this.type.create(var3, EntitySpawnReason.DISPENSER);
        if (var16 != null) {
            var16.setInitialPos(var7, var9 + var14, var11);
            EntityTypes.createDefaultStackConfig(var3, var1, null).accept(var16);
            var16.setYRot(var2.toYRot());
            var3.addFreshEntity(var16);
            var1.shrink(1);
        }
        return var1;
    }

    @Override
    protected void playSound(SourceBlock var0) {
        var0.level().levelEvent(1000, var0.pos(), 0);
    }
}

