/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import org.jspecify.annotations.Nullable;

public class DefaultedMappedRegistry<T>
extends RegistryMaterials<T>
implements RegistryBlocks<T> {
    private final MinecraftKey defaultKey;
    private Holder.c<T> defaultValue;

    public DefaultedMappedRegistry(String var0, ResourceKey<? extends IRegistry<T>> var1, Lifecycle var2, boolean var3) {
        super(var1, var2, var3);
        this.defaultKey = MinecraftKey.parse(var0);
    }

    @Override
    public Holder.c<T> register(ResourceKey<T> var0, T var1, RegistrationInfo var2) {
        Holder.c<T> var3 = super.register(var0, var1, var2);
        if (this.defaultKey.equals(var0.identifier())) {
            this.defaultValue = var3;
        }
        return var3;
    }

    @Override
    public int getId(@Nullable T var0) {
        int var1 = super.getId(var0);
        return var1 == -1 ? super.getId(this.defaultValue.value()) : var1;
    }

    @Override
    public MinecraftKey getKey(T var0) {
        MinecraftKey var1 = super.getKey(var0);
        return var1 == null ? this.defaultKey : var1;
    }

    @Override
    public T getValue(@Nullable MinecraftKey var0) {
        Object var1 = super.getValue(var0);
        return var1 == null ? this.defaultValue.value() : var1;
    }

    @Override
    public Optional<T> getOptional(@Nullable MinecraftKey var0) {
        return Optional.ofNullable(super.getValue(var0));
    }

    @Override
    public Optional<Holder.c<T>> getAny() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public T byId(int var0) {
        Object var1 = super.byId(var0);
        return var1 == null ? this.defaultValue.value() : var1;
    }

    @Override
    public Optional<Holder.c<T>> getRandom(RandomSource var0) {
        return super.getRandom(var0).or(() -> Optional.of(this.defaultValue));
    }

    @Override
    public MinecraftKey getDefaultKey() {
        return this.defaultKey;
    }
}

