/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import org.joml.Vector3i;

@Immutable
public class BaseBlockPosition
implements Comparable<BaseBlockPosition> {
    public static final Codec<BaseBlockPosition> CODEC = Codec.INT_STREAM.comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 3).map(var0 -> new BaseBlockPosition(var0[0], var0[1], var0[2])), var0 -> IntStream.of(var0.getX(), var0.getY(), var0.getZ()));
    public static final StreamCodec<ByteBuf, BaseBlockPosition> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, BaseBlockPosition::getX, ByteBufCodecs.VAR_INT, BaseBlockPosition::getY, ByteBufCodecs.VAR_INT, BaseBlockPosition::getZ, BaseBlockPosition::new);
    public static final BaseBlockPosition ZERO = new BaseBlockPosition(0, 0, 0);
    private int x;
    private int y;
    private int z;

    public static Codec<BaseBlockPosition> offsetCodec(int var0) {
        return CODEC.validate(var1 -> {
            if (Math.abs(var1.getX()) < var0 && Math.abs(var1.getY()) < var0 && Math.abs(var1.getZ()) < var0) {
                return DataResult.success((Object)var1);
            }
            return DataResult.error(() -> "Position out of range, expected at most " + var0 + ": " + String.valueOf(var1));
        });
    }

    public BaseBlockPosition(int var0, int var1, int var2) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof BaseBlockPosition)) {
            return false;
        }
        BaseBlockPosition var1 = (BaseBlockPosition)var0;
        return this.getX() == var1.getX() && this.getY() == var1.getY() && this.getZ() == var1.getZ();
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    @Override
    public int compareTo(BaseBlockPosition var0) {
        if (this.getY() == var0.getY()) {
            if (this.getZ() == var0.getZ()) {
                return this.getX() - var0.getX();
            }
            return this.getZ() - var0.getZ();
        }
        return this.getY() - var0.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    protected BaseBlockPosition setX(int var0) {
        this.x = var0;
        return this;
    }

    protected BaseBlockPosition setY(int var0) {
        this.y = var0;
        return this;
    }

    protected BaseBlockPosition setZ(int var0) {
        this.z = var0;
        return this;
    }

    public BaseBlockPosition offset(int var0, int var1, int var2) {
        if (var0 == 0 && var1 == 0 && var2 == 0) {
            return this;
        }
        return new BaseBlockPosition(this.getX() + var0, this.getY() + var1, this.getZ() + var2);
    }

    public BaseBlockPosition offset(BaseBlockPosition var0) {
        return this.offset(var0.getX(), var0.getY(), var0.getZ());
    }

    public BaseBlockPosition subtract(BaseBlockPosition var0) {
        return this.offset(-var0.getX(), -var0.getY(), -var0.getZ());
    }

    public BaseBlockPosition multiply(int var0) {
        if (var0 == 1) {
            return this;
        }
        if (var0 == 0) {
            return ZERO;
        }
        return new BaseBlockPosition(this.getX() * var0, this.getY() * var0, this.getZ() * var0);
    }

    public BaseBlockPosition multiply(int var0, int var1, int var2) {
        return new BaseBlockPosition(this.getX() * var0, this.getY() * var1, this.getZ() * var2);
    }

    public BaseBlockPosition above() {
        return this.above(1);
    }

    public BaseBlockPosition above(int var0) {
        return this.relative(EnumDirection.UP, var0);
    }

    public BaseBlockPosition below() {
        return this.below(1);
    }

    public BaseBlockPosition below(int var0) {
        return this.relative(EnumDirection.DOWN, var0);
    }

    public BaseBlockPosition north() {
        return this.north(1);
    }

    public BaseBlockPosition north(int var0) {
        return this.relative(EnumDirection.NORTH, var0);
    }

    public BaseBlockPosition south() {
        return this.south(1);
    }

    public BaseBlockPosition south(int var0) {
        return this.relative(EnumDirection.SOUTH, var0);
    }

    public BaseBlockPosition west() {
        return this.west(1);
    }

    public BaseBlockPosition west(int var0) {
        return this.relative(EnumDirection.WEST, var0);
    }

    public BaseBlockPosition east() {
        return this.east(1);
    }

    public BaseBlockPosition east(int var0) {
        return this.relative(EnumDirection.EAST, var0);
    }

    public BaseBlockPosition relative(EnumDirection var0) {
        return this.relative(var0, 1);
    }

    public BaseBlockPosition relative(EnumDirection var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        return new BaseBlockPosition(this.getX() + var0.getStepX() * var1, this.getY() + var0.getStepY() * var1, this.getZ() + var0.getStepZ() * var1);
    }

    public BaseBlockPosition relative(EnumDirection.EnumAxis var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        int var2 = var0 == EnumDirection.EnumAxis.X ? var1 : 0;
        int var3 = var0 == EnumDirection.EnumAxis.Y ? var1 : 0;
        int var4 = var0 == EnumDirection.EnumAxis.Z ? var1 : 0;
        return new BaseBlockPosition(this.getX() + var2, this.getY() + var3, this.getZ() + var4);
    }

    public BaseBlockPosition cross(BaseBlockPosition var0) {
        return new BaseBlockPosition(this.getY() * var0.getZ() - this.getZ() * var0.getY(), this.getZ() * var0.getX() - this.getX() * var0.getZ(), this.getX() * var0.getY() - this.getY() * var0.getX());
    }

    public boolean closerThan(BaseBlockPosition var0, double var1) {
        return this.distSqr(var0) < MathHelper.square(var1);
    }

    public boolean closerToCenterThan(IPosition var0, double var1) {
        return this.distToCenterSqr(var0) < MathHelper.square(var1);
    }

    public double distSqr(BaseBlockPosition var0) {
        return this.distToLowCornerSqr(var0.getX(), var0.getY(), var0.getZ());
    }

    public double distToCenterSqr(IPosition var0) {
        return this.distToCenterSqr(var0.x(), var0.y(), var0.z());
    }

    public double distToCenterSqr(double var0, double var2, double var4) {
        double var6 = (double)this.getX() + 0.5 - var0;
        double var8 = (double)this.getY() + 0.5 - var2;
        double var10 = (double)this.getZ() + 0.5 - var4;
        return var6 * var6 + var8 * var8 + var10 * var10;
    }

    public double distToLowCornerSqr(double var0, double var2, double var4) {
        double var6 = (double)this.getX() - var0;
        double var8 = (double)this.getY() - var2;
        double var10 = (double)this.getZ() - var4;
        return var6 * var6 + var8 * var8 + var10 * var10;
    }

    public int distManhattan(BaseBlockPosition var0) {
        float var1 = Math.abs(var0.getX() - this.getX());
        float var2 = Math.abs(var0.getY() - this.getY());
        float var3 = Math.abs(var0.getZ() - this.getZ());
        return (int)(var1 + var2 + var3);
    }

    public int distChessboard(BaseBlockPosition var0) {
        int var1 = Math.abs(this.getX() - var0.getX());
        int var2 = Math.abs(this.getY() - var0.getY());
        int var3 = Math.abs(this.getZ() - var0.getZ());
        return Math.max(Math.max(var1, var2), var3);
    }

    public int get(EnumDirection.EnumAxis var0) {
        return var0.choose(this.x, this.y, this.z);
    }

    public Vector3i toMutable() {
        return new Vector3i(this.x, this.y, this.z);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.getX()).add("y", this.getY()).add("z", this.getZ()).toString();
    }

    public String toShortString() {
        return this.getX() + ", " + this.getY() + ", " + this.getZ();
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((BaseBlockPosition)object);
    }
}

