/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.execution.tasks.BuildContexts;
import net.minecraft.commands.functions.FunctionBuilder;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import org.jspecify.annotations.Nullable;

public interface CommandFunction<T> {
    public MinecraftKey id();

    public InstantiatedFunction<T> instantiate(@Nullable NBTTagCompound var1, com.mojang.brigadier.CommandDispatcher<T> var2) throws FunctionInstantiationException;

    private static boolean shouldConcatenateNextLine(CharSequence var0) {
        int var1 = var0.length();
        return var1 > 0 && var0.charAt(var1 - 1) == '\\';
    }

    public static <T extends ExecutionCommandSource<T>> CommandFunction<T> fromLines(MinecraftKey var0, com.mojang.brigadier.CommandDispatcher<T> var1, T var2, List<String> var3) {
        FunctionBuilder<T> var4 = new FunctionBuilder<T>();
        for (int var5 = 0; var5 < var3.size(); ++var5) {
            String var8;
            String var10;
            StringBuilder var9;
            int var6 = var5 + 1;
            String var7 = var3.get(var5).trim();
            if (CommandFunction.shouldConcatenateNextLine(var7)) {
                var9 = new StringBuilder(var7);
                do {
                    if (++var5 == var3.size()) {
                        throw new IllegalArgumentException("Line continuation at end of file");
                    }
                    var9.deleteCharAt(var9.length() - 1);
                    var10 = var3.get(var5).trim();
                    var9.append(var10);
                    CommandFunction.checkCommandLineLength(var9);
                } while (CommandFunction.shouldConcatenateNextLine(var9));
                var8 = var9.toString();
            } else {
                var8 = var7;
            }
            CommandFunction.checkCommandLineLength(var8);
            var9 = new StringReader(var8);
            if (!var9.canRead() || var9.peek() == '#') continue;
            if (var9.peek() == '/') {
                var9.skip();
                if (var9.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + var8 + "' on line " + var6 + " (if you intended to make a comment, use '#' not '//')");
                }
                var10 = var9.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + var8 + "' on line " + var6 + " (did you mean '" + var10 + "'? Do not use a preceding forwards slash.)");
            }
            if (var9.peek() == '$') {
                var4.addMacro(var8.substring(1), var6, var2);
                continue;
            }
            try {
                var4.addCommand(CommandFunction.parseCommand(var1, var2, (StringReader)var9));
                continue;
            }
            catch (CommandSyntaxException var102) {
                throw new IllegalArgumentException("Whilst parsing command on line " + var6 + ": " + var102.getMessage());
            }
        }
        return var4.build(var0);
    }

    public static void checkCommandLineLength(CharSequence var0) {
        if (var0.length() > 2000000) {
            CharSequence var1 = var0.subSequence(0, Math.min(512, 2000000));
            throw new IllegalStateException("Command too long: " + var0.length() + " characters, contents: " + String.valueOf(var1) + "...");
        }
    }

    public static <T extends ExecutionCommandSource<T>> UnboundEntryAction<T> parseCommand(com.mojang.brigadier.CommandDispatcher<T> var0, T var1, StringReader var2) throws CommandSyntaxException {
        ParseResults var3 = var0.parse(var2, var1);
        CommandDispatcher.validateParseResults(var3);
        Optional var4 = ContextChain.tryFlatten((CommandContext)var3.getContext().build(var2.getString()));
        if (var4.isEmpty()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(var3.getReader());
        }
        return new BuildContexts.c(var2.getString(), (ContextChain)var4.get());
    }
}

