/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentParserPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public record ArgumentVectorPosition(double left, double up, double forwards) implements IVectorPosition
{
    public static final char PREFIX_LOCAL_COORDINATE = '^';

    @Override
    public Vec3D getPosition(CommandListenerWrapper var0) {
        Vec3D var1 = var0.getAnchor().apply(var0);
        return Vec3D.applyLocalCoordinatesToRotation(var0.getRotation(), new Vec3D(this.left, this.up, this.forwards)).add(var1.x, var1.y, var1.z);
    }

    @Override
    public Vec2F getRotation(CommandListenerWrapper var0) {
        return Vec2F.ZERO;
    }

    @Override
    public boolean isXRelative() {
        return true;
    }

    @Override
    public boolean isYRelative() {
        return true;
    }

    @Override
    public boolean isZRelative() {
        return true;
    }

    public static ArgumentVectorPosition parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        double var2 = ArgumentVectorPosition.readDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ArgumentVec3.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        double var4 = ArgumentVectorPosition.readDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ArgumentVec3.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        double var6 = ArgumentVectorPosition.readDouble(var0, var1);
        return new ArgumentVectorPosition(var2, var4, var6);
    }

    private static double readDouble(StringReader var0, int var1) throws CommandSyntaxException {
        if (!var0.canRead()) {
            throw ArgumentParserPosition.ERROR_EXPECTED_DOUBLE.createWithContext((ImmutableStringReader)var0);
        }
        if (var0.peek() != '^') {
            var0.setCursor(var1);
            throw ArgumentVec3.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        return var0.canRead() && var0.peek() != ' ' ? var0.readDouble() : 0.0;
    }
}

