/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;

public class ResourceArgument<T>
implements ArgumentType<Holder.c<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_NOT_SUMMONABLE_ENTITY = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("entity.not_summonable", var0));
    public static final Dynamic2CommandExceptionType ERROR_UNKNOWN_RESOURCE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("argument.resource.not_found", var0, var1));
    public static final Dynamic3CommandExceptionType ERROR_INVALID_RESOURCE_TYPE = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.translatableEscape("argument.resource.invalid_type", var0, var1, var2));
    final ResourceKey<? extends IRegistry<T>> registryKey;
    private final HolderLookup<T> registryLookup;

    public ResourceArgument(CommandBuildContext var0, ResourceKey<? extends IRegistry<T>> var1) {
        this.registryKey = var1;
        this.registryLookup = var0.lookupOrThrow(var1);
    }

    public static <T> ResourceArgument<T> resource(CommandBuildContext var0, ResourceKey<? extends IRegistry<T>> var1) {
        return new ResourceArgument<T>(var0, var1);
    }

    public static <T> Holder.c<T> getResource(CommandContext<CommandListenerWrapper> var0, String var1, ResourceKey<IRegistry<T>> var2) throws CommandSyntaxException {
        Holder.c var3 = (Holder.c)var0.getArgument(var1, Holder.c.class);
        ResourceKey var4 = var3.key();
        if (var4.isFor(var2)) {
            return var3;
        }
        throw ERROR_INVALID_RESOURCE_TYPE.create((Object)var4.identifier(), (Object)var4.registry(), (Object)var2.identifier());
    }

    public static Holder.c<AttributeBase> getAttribute(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.ATTRIBUTE);
    }

    public static Holder.c<WorldGenFeatureConfigured<?, ?>> getConfiguredFeature(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.CONFIGURED_FEATURE);
    }

    public static Holder.c<Structure> getStructure(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.STRUCTURE);
    }

    public static Holder.c<EntityTypes<?>> getEntityType(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.ENTITY_TYPE);
    }

    public static Holder.c<EntityTypes<?>> getSummonableEntityType(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        Holder.c<EntityTypes<?>> var2 = ResourceArgument.getResource(var0, var1, Registries.ENTITY_TYPE);
        if (!((EntityTypes)var2.value()).canSummon()) {
            throw ERROR_NOT_SUMMONABLE_ENTITY.create((Object)var2.key().identifier().toString());
        }
        return var2;
    }

    public static Holder.c<MobEffectList> getMobEffect(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.MOB_EFFECT);
    }

    public static Holder.c<Enchantment> getEnchantment(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.ENCHANTMENT);
    }

    public Holder.c<T> parse(StringReader var0) throws CommandSyntaxException {
        MinecraftKey var1 = MinecraftKey.read(var0);
        ResourceKey var2 = ResourceKey.create(this.registryKey, var1);
        return this.registryLookup.get(var2).orElseThrow(() -> ERROR_UNKNOWN_RESOURCE.createWithContext((ImmutableStringReader)var0, (Object)var1, (Object)this.registryKey.identifier()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.listSuggestions(var0, var1, this.registryKey, ICompletionProvider.a.ELEMENTS);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class net.minecraft.commands.arguments.ResourceArgument$a<T>
    implements ArgumentTypeInfo<ResourceArgument<T>, a> {
        @Override
        public void serializeToNetwork(a var0, PacketDataSerializer var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public a deserializeFromNetwork(PacketDataSerializer var0) {
            return new a(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(a var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.identifier().toString());
        }

        @Override
        public a unpack(ResourceArgument<T> var0) {
            return new a(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> registryKey;

            a(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceArgument(var0, this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceArgument<T>, ?> type() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

