/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionConditionEntity;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.advancements.criterion.CriterionTriggerAbstract;
import net.minecraft.advancements.criterion.CriterionValidator;
import net.minecraft.core.HolderGetter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import org.jspecify.annotations.Nullable;

public class KilledByArrowTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, Collection<Entity> var1, @Nullable ItemStack var2) {
        ArrayList var32 = Lists.newArrayList();
        HashSet var4 = Sets.newHashSet();
        for (Entity var6 : var1) {
            var4.add(var6.getType());
            var32.add(CriterionConditionEntity.createContext(var0, var6));
        }
        this.trigger(var0, var3 -> var3.matches(var32, var4.size(), var2));
    }

    public record a(Optional<ContextAwarePredicate> player, List<ContextAwarePredicate> victims, CriterionConditionValue.IntegerRange uniqueEntityTypes, Optional<CriterionConditionItem> firedFromWeapon) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(a::player), (App)CriterionConditionEntity.ADVANCEMENT_CODEC.listOf().optionalFieldOf("victims", List.of()).forGetter(a::victims), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("unique_entity_types", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(a::uniqueEntityTypes), (App)CriterionConditionItem.CODEC.optionalFieldOf("fired_from_weapon").forGetter(a::firedFromWeapon)).apply((Applicative)var0, a::new));

        public static Criterion<a> crossbowKilled(HolderGetter<Item> var0, CriterionConditionEntity.a ... var1) {
            return CriterionTriggers.KILLED_BY_ARROW.createCriterion(new a(Optional.empty(), CriterionConditionEntity.wrap(var1), CriterionConditionValue.IntegerRange.ANY, Optional.of(CriterionConditionItem.a.item().of(var0, Items.CROSSBOW).build())));
        }

        public static Criterion<a> crossbowKilled(HolderGetter<Item> var0, CriterionConditionValue.IntegerRange var1) {
            return CriterionTriggers.KILLED_BY_ARROW.createCriterion(new a(Optional.empty(), List.of(), var1, Optional.of(CriterionConditionItem.a.item().of(var0, Items.CROSSBOW).build())));
        }

        public boolean matches(Collection<LootTableInfo> var0, int var1, @Nullable ItemStack var2) {
            if (this.firedFromWeapon.isPresent() && (var2 == null || !this.firedFromWeapon.get().test(var2))) {
                return false;
            }
            if (!this.victims.isEmpty()) {
                ArrayList var3 = Lists.newArrayList(var0);
                for (ContextAwarePredicate var5 : this.victims) {
                    boolean var6 = false;
                    Iterator var7 = var3.iterator();
                    while (var7.hasNext()) {
                        LootTableInfo var8 = (LootTableInfo)var7.next();
                        if (!var5.matches(var8)) continue;
                        var7.remove();
                        var6 = true;
                        break;
                    }
                    if (var6) continue;
                    return false;
                }
            }
            return this.uniqueEntityTypes.matches(var1);
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            var0.validateEntities(this.victims, "victims");
        }
    }
}

