/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionConditionEntity;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.advancements.criterion.CriterionTriggerAbstract;
import net.minecraft.advancements.criterion.CriterionValidator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class CriterionTriggerPlayerInteractedWithEntity
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, ItemStack var1, Entity var22) {
        LootTableInfo var3 = CriterionConditionEntity.createContext(var0, var22);
        this.trigger(var0, var2 -> var2.matches(var1, var3));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<CriterionConditionItem> item, Optional<ContextAwarePredicate> entity) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(a::player), (App)CriterionConditionItem.CODEC.optionalFieldOf("item").forGetter(a::item), (App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(a::entity)).apply((Applicative)var0, a::new));

        public static Criterion<a> itemUsedOnEntity(Optional<ContextAwarePredicate> var0, CriterionConditionItem.a var1, Optional<ContextAwarePredicate> var2) {
            return CriterionTriggers.PLAYER_INTERACTED_WITH_ENTITY.createCriterion(new a(var0, Optional.of(var1.build()), var2));
        }

        public static Criterion<a> equipmentSheared(Optional<ContextAwarePredicate> var0, CriterionConditionItem.a var1, Optional<ContextAwarePredicate> var2) {
            return CriterionTriggers.PLAYER_SHEARED_EQUIPMENT.createCriterion(new a(var0, Optional.of(var1.build()), var2));
        }

        public static Criterion<a> equipmentSheared(CriterionConditionItem.a var0, Optional<ContextAwarePredicate> var1) {
            return CriterionTriggers.PLAYER_SHEARED_EQUIPMENT.createCriterion(new a(Optional.empty(), Optional.of(var0.build()), var1));
        }

        public static Criterion<a> itemUsedOnEntity(CriterionConditionItem.a var0, Optional<ContextAwarePredicate> var1) {
            return a.itemUsedOnEntity(Optional.empty(), var0, var1);
        }

        public boolean matches(ItemStack var0, LootTableInfo var1) {
            if (this.item.isPresent() && !this.item.get().test(var0)) {
                return false;
            }
            return this.entity.isEmpty() || this.entity.get().matches(var1);
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            var0.validateEntity(this.entity, "entity");
        }
    }
}

