/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionConditionEntity;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.advancements.criterion.CriterionTriggerAbstract;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public class CriterionTriggerInventoryChanged
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, PlayerInventory var1, ItemStack var2) {
        int var3 = 0;
        int var4 = 0;
        int var5 = 0;
        for (int var6 = 0; var6 < var1.getContainerSize(); ++var6) {
            ItemStack var7 = var1.getItem(var6);
            if (var7.isEmpty()) {
                ++var4;
                continue;
            }
            ++var5;
            if (var7.getCount() < var7.getMaxStackSize()) continue;
            ++var3;
        }
        this.trigger(var0, var1, var2, var3, var4, var5);
    }

    private void trigger(EntityPlayer var0, PlayerInventory var1, ItemStack var2, int var3, int var4, int var52) {
        this.trigger(var0, var5 -> var5.matches(var1, var2, var3, var4, var52));
    }

    public record net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a(Optional<ContextAwarePredicate> player, a slots, List<CriterionConditionItem> items) implements CriterionTriggerAbstract.a
    {
        public static final Codec<net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a::player), (App)a.CODEC.optionalFieldOf("slots", (Object)a.ANY).forGetter(net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a::slots), (App)CriterionConditionItem.CODEC.listOf().optionalFieldOf("items", List.of()).forGetter(net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a::items)).apply((Applicative)var0, net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a::new));

        public static Criterion<net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a> hasItems(CriterionConditionItem.a ... var0) {
            return net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a.hasItems((CriterionConditionItem[])Stream.of(var0).map(CriterionConditionItem.a::build).toArray(CriterionConditionItem[]::new));
        }

        public static Criterion<net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a> hasItems(CriterionConditionItem ... var0) {
            return CriterionTriggers.INVENTORY_CHANGED.createCriterion(new net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a(Optional.empty(), a.ANY, List.of(var0)));
        }

        public static Criterion<net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a> hasItems(IMaterial ... var0) {
            CriterionConditionItem[] var1 = new CriterionConditionItem[var0.length];
            for (int var2 = 0; var2 < var0.length; ++var2) {
                var1[var2] = new CriterionConditionItem(Optional.of(HolderSet.direct(var0[var2].asItem().builtInRegistryHolder())), CriterionConditionValue.IntegerRange.ANY, DataComponentMatchers.ANY);
            }
            return net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged$a.hasItems(var1);
        }

        public boolean matches(PlayerInventory var0, ItemStack var12, int var2, int var3, int var4) {
            if (!this.slots.matches(var2, var3, var4)) {
                return false;
            }
            if (this.items.isEmpty()) {
                return true;
            }
            if (this.items.size() == 1) {
                return !var12.isEmpty() && this.items.get(0).test(var12);
            }
            ObjectArrayList var5 = new ObjectArrayList(this.items);
            int var6 = var0.getContainerSize();
            for (int var7 = 0; var7 < var6; ++var7) {
                if (var5.isEmpty()) {
                    return true;
                }
                ItemStack var8 = var0.getItem(var7);
                if (var8.isEmpty()) continue;
                var5.removeIf(var1 -> var1.test(var8));
            }
            return var5.isEmpty();
        }

        public record a(CriterionConditionValue.IntegerRange occupied, CriterionConditionValue.IntegerRange full, CriterionConditionValue.IntegerRange empty) {
            public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("occupied", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(a::occupied), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("full", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(a::full), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("empty", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(a::empty)).apply((Applicative)var0, a::new));
            public static final a ANY = new a(CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY);

            public boolean matches(int var0, int var1, int var2) {
                if (!this.full.matches(var0)) {
                    return false;
                }
                if (!this.empty.matches(var1)) {
                    return false;
                }
                return this.occupied.matches(var2);
            }
        }
    }
}

