/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.storage.TagValueOutput;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public record CriterionConditionNBT(NBTTagCompound tag) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<CriterionConditionNBT> CODEC = MojangsonParser.LENIENT_CODEC.xmap(CriterionConditionNBT::new, CriterionConditionNBT::tag);
    public static final StreamCodec<ByteBuf, CriterionConditionNBT> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(CriterionConditionNBT::new, CriterionConditionNBT::tag);
    public static final String SELECTED_ITEM_TAG = "SelectedItem";

    public boolean matches(DataComponentGetter var0) {
        CustomData var1 = var0.getOrDefault(DataComponents.CUSTOM_DATA, CustomData.EMPTY);
        return var1.matchedBy(this.tag);
    }

    public boolean matches(Entity var0) {
        return this.matches(CriterionConditionNBT.getEntityTagToCompare(var0));
    }

    public boolean matches(@Nullable NBTBase var0) {
        return var0 != null && GameProfileSerializer.compareNbt(this.tag, var0, true);
    }

    public static NBTTagCompound getEntityTagToCompare(Entity var0) {
        try (ProblemReporter.j var1 = new ProblemReporter.j(var0.problemPath(), LOGGER);){
            EntityHuman var3;
            ItemStack var4;
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0.registryAccess());
            var0.saveWithoutId(var2);
            if (var0 instanceof EntityHuman && !(var4 = (var3 = (EntityHuman)var0).getInventory().getSelectedItem()).isEmpty()) {
                var2.store(SELECTED_ITEM_TAG, ItemStack.CODEC, var4);
            }
            NBTTagCompound nBTTagCompound = var2.buildResult();
            return nBTTagCompound;
        }
    }
}

