/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.criterion.EntitySubPredicate;
import net.minecraft.advancements.criterion.EntitySubPredicates;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public record CriterionConditionInOpenWater(Optional<Boolean> inOpenWater) implements EntitySubPredicate
{
    public static final CriterionConditionInOpenWater ANY = new CriterionConditionInOpenWater(Optional.empty());
    public static final MapCodec<CriterionConditionInOpenWater> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.BOOL.optionalFieldOf("in_open_water").forGetter(CriterionConditionInOpenWater::inOpenWater)).apply((Applicative)var0, CriterionConditionInOpenWater::new));

    public static CriterionConditionInOpenWater inOpenWater(boolean var0) {
        return new CriterionConditionInOpenWater(Optional.of(var0));
    }

    public MapCodec<CriterionConditionInOpenWater> codec() {
        return EntitySubPredicates.FISHING_HOOK;
    }

    @Override
    public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var2) {
        if (this.inOpenWater.isEmpty()) {
            return true;
        }
        if (var0 instanceof EntityFishingHook) {
            EntityFishingHook var3 = (EntityFishingHook)var0;
            return this.inOpenWater.get().booleanValue() == var3.isOpenWaterFishing();
        }
        return false;
    }
}

