/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.resources.MinecraftKey;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class AdvancementTree {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<MinecraftKey, AdvancementNode> nodes = new Object2ObjectOpenHashMap();
    private final Set<AdvancementNode> roots = new ObjectLinkedOpenHashSet();
    private final Set<AdvancementNode> tasks = new ObjectLinkedOpenHashSet();
    private @Nullable a listener;

    private void remove(AdvancementNode var0) {
        for (AdvancementNode var2 : var0.children()) {
            this.remove(var2);
        }
        LOGGER.info("Forgot about advancement {}", (Object)var0.holder());
        this.nodes.remove(var0.holder().id());
        if (var0.parent() == null) {
            this.roots.remove(var0);
            if (this.listener != null) {
                this.listener.onRemoveAdvancementRoot(var0);
            }
        } else {
            this.tasks.remove(var0);
            if (this.listener != null) {
                this.listener.onRemoveAdvancementTask(var0);
            }
        }
    }

    public void remove(Set<MinecraftKey> var0) {
        for (MinecraftKey var2 : var0) {
            AdvancementNode var3 = this.nodes.get(var2);
            if (var3 == null) {
                LOGGER.warn("Told to remove advancement {} but I don't know what that is", (Object)var2);
                continue;
            }
            this.remove(var3);
        }
    }

    public void addAll(Collection<AdvancementHolder> var0) {
        ArrayList<AdvancementHolder> var1 = new ArrayList<AdvancementHolder>(var0);
        while (!var1.isEmpty()) {
            if (var1.removeIf(this::tryInsert)) continue;
            LOGGER.error("Couldn't load advancements: {}", var1);
            break;
        }
        LOGGER.info("Loaded {} advancements", (Object)this.nodes.size());
    }

    private boolean tryInsert(AdvancementHolder var0) {
        Optional<MinecraftKey> var1 = var0.value().parent();
        AdvancementNode var2 = var1.map(this.nodes::get).orElse(null);
        if (var2 == null && var1.isPresent()) {
            return false;
        }
        AdvancementNode var3 = new AdvancementNode(var0, var2);
        if (var2 != null) {
            var2.addChild(var3);
        }
        this.nodes.put(var0.id(), var3);
        if (var2 == null) {
            this.roots.add(var3);
            if (this.listener != null) {
                this.listener.onAddAdvancementRoot(var3);
            }
        } else {
            this.tasks.add(var3);
            if (this.listener != null) {
                this.listener.onAddAdvancementTask(var3);
            }
        }
        return true;
    }

    public void clear() {
        this.nodes.clear();
        this.roots.clear();
        this.tasks.clear();
        if (this.listener != null) {
            this.listener.onAdvancementsCleared();
        }
    }

    public Iterable<AdvancementNode> roots() {
        return this.roots;
    }

    public Collection<AdvancementNode> nodes() {
        return this.nodes.values();
    }

    public @Nullable AdvancementNode get(MinecraftKey var0) {
        return this.nodes.get(var0);
    }

    public @Nullable AdvancementNode get(AdvancementHolder var0) {
        return this.nodes.get(var0.id());
    }

    public void setListener(@Nullable a var0) {
        this.listener = var0;
        if (var0 != null) {
            for (AdvancementNode var2 : this.roots) {
                var0.onAddAdvancementRoot(var2);
            }
            for (AdvancementNode var2 : this.tasks) {
                var0.onAddAdvancementTask(var2);
            }
        }
    }

    public static interface a {
        public void onAddAdvancementRoot(AdvancementNode var1);

        public void onRemoveAdvancementRoot(AdvancementNode var1);

        public void onAddAdvancementTask(AdvancementNode var1);

        public void onRemoveAdvancementTask(AdvancementNode var1);

        public void onAdvancementsCleared();
    }
}

