/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class ContextNbtProvider
implements NbtProvider {
    private static final ExtraCodecs.b<String, c<?>> SOURCES = new ExtraCodecs.b();
    private static final Codec<c<?>> GETTER_CODEC;
    public static final MapCodec<ContextNbtProvider> MAP_CODEC;
    public static final Codec<ContextNbtProvider> INLINE_CODEC;
    private final c<?> source;

    private ContextNbtProvider(c<?> var0) {
        this.source = var0;
    }

    @Override
    public LootNbtProviderType getType() {
        return NbtProviders.CONTEXT;
    }

    @Override
    @Nullable
    public NBTBase get(LootTableInfo var0) {
        return this.source.get(var0);
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.contextParam());
    }

    public static NbtProvider forContextEntity(LootTableInfo.EntityTarget var0) {
        return new ContextNbtProvider(new b(var0.getParam()));
    }

    static {
        for (LootTableInfo.EntityTarget entityTarget : LootTableInfo.EntityTarget.values()) {
            SOURCES.put(entityTarget.getSerializedName(), new b(entityTarget.getParam()));
        }
        for (Enum enum_ : LootTableInfo.a.values()) {
            SOURCES.put(((LootTableInfo.a)enum_).getSerializedName(), new a(((LootTableInfo.a)enum_).getParam()));
        }
        GETTER_CODEC = SOURCES.codec((Codec<String>)Codec.STRING);
        MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)GETTER_CODEC.fieldOf("target").forGetter(var0 -> var0.source)).apply((Applicative)var02, ContextNbtProvider::new));
        INLINE_CODEC = GETTER_CODEC.xmap(ContextNbtProvider::new, var0 -> var0.source);
    }

    static interface c<T> {
        public ContextKey<? extends T> contextParam();

        @Nullable
        public NBTBase get(T var1);

        @Nullable
        default public NBTBase get(LootTableInfo var0) {
            T var1 = var0.getOptionalParameter(this.contextParam());
            return var1 != null ? this.get(var1) : null;
        }
    }

    record b(ContextKey<? extends Entity> contextParam) implements c<Entity>
    {
        @Override
        public NBTBase get(Entity var0) {
            return CriterionConditionNBT.getEntityTagToCompare(var0);
        }
    }

    record a(ContextKey<? extends TileEntity> contextParam) implements c<TileEntity>
    {
        @Override
        public NBTBase get(TileEntity var0) {
            return var0.saveWithFullMetadata(var0.getLevel().registryAccess());
        }
    }
}

