/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetLore
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionSetLore> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionSetLore.commonFields(var02).and(var02.group((App)ComponentSerialization.CODEC.sizeLimitedListOf(256).fieldOf("lore").forGetter(var0 -> var0.lore), (App)ListOperation.codec(256).forGetter(var0 -> var0.mode), (App)LootTableInfo.EntityTarget.CODEC.optionalFieldOf("entity").forGetter(var0 -> var0.resolutionContext))).apply((Applicative)var02, LootItemFunctionSetLore::new));
    private final List<IChatBaseComponent> lore;
    private final ListOperation mode;
    private final Optional<LootTableInfo.EntityTarget> resolutionContext;

    public LootItemFunctionSetLore(List<LootItemCondition> var0, List<IChatBaseComponent> var1, ListOperation var2, Optional<LootTableInfo.EntityTarget> var3) {
        super(var0);
        this.lore = List.copyOf(var1);
        this.mode = var2;
        this.resolutionContext = var3;
    }

    public LootItemFunctionType<LootItemFunctionSetLore> getType() {
        return LootItemFunctions.SET_LORE;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.resolutionContext.map(var0 -> Set.of(var0.getParam())).orElseGet(Set::of);
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var12) {
        var0.update(DataComponents.LORE, ItemLore.EMPTY, var1 -> new ItemLore(this.updateLore((ItemLore)var1, var12)));
        return var0;
    }

    private List<IChatBaseComponent> updateLore(@Nullable ItemLore var0, LootTableInfo var1) {
        if (var0 == null && this.lore.isEmpty()) {
            return List.of();
        }
        UnaryOperator<IChatBaseComponent> var2 = LootItemFunctionSetName.createResolver(var1, this.resolutionContext.orElse(null));
        List var3 = this.lore.stream().map(var2).toList();
        return this.mode.apply(var0.lines(), var3, 256);
    }

    public static a setLore() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private Optional<LootTableInfo.EntityTarget> resolutionContext = Optional.empty();
        private final ImmutableList.Builder<IChatBaseComponent> lore = ImmutableList.builder();
        private ListOperation mode = ListOperation.a.INSTANCE;

        public a setMode(ListOperation var0) {
            this.mode = var0;
            return this;
        }

        public a setResolutionContext(LootTableInfo.EntityTarget var0) {
            this.resolutionContext = Optional.of(var0);
            return this;
        }

        public a addLine(IChatBaseComponent var0) {
            this.lore.add((Object)var0);
            return this;
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetLore(this.getConditions(), (List<IChatBaseComponent>)this.lore.build(), this.mode, this.resolutionContext);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

