/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;

public class MobSpawnerPatrol
implements MobSpawner {
    private int nextTick;

    @Override
    public void tick(WorldServer var0, boolean var1) {
        if (!var1) {
            return;
        }
        if (!var0.getGameRules().getBoolean(GameRules.RULE_DO_PATROL_SPAWNING)) {
            return;
        }
        RandomSource var2 = var0.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return;
        }
        this.nextTick += 12000 + var2.nextInt(1200);
        long var3 = var0.getDayTime() / 24000L;
        if (var3 < 5L || !var0.isBrightOutside()) {
            return;
        }
        if (var2.nextInt(5) != 0) {
            return;
        }
        int var5 = var0.players().size();
        if (var5 < 1) {
            return;
        }
        EntityHuman var6 = var0.players().get(var2.nextInt(var5));
        if (var6.isSpectator()) {
            return;
        }
        if (var0.isCloseToVillage(var6.blockPosition(), 2)) {
            return;
        }
        int var7 = (24 + var2.nextInt(24)) * (var2.nextBoolean() ? -1 : 1);
        int var8 = (24 + var2.nextInt(24)) * (var2.nextBoolean() ? -1 : 1);
        BlockPosition.MutableBlockPosition var9 = var6.blockPosition().mutable().move(var7, 0, var8);
        int var10 = 10;
        if (!var0.hasChunksAt(var9.getX() - 10, var9.getZ() - 10, var9.getX() + 10, var9.getZ() + 10)) {
            return;
        }
        Holder<BiomeBase> var11 = var0.getBiome(var9);
        if (var11.is(BiomeTags.WITHOUT_PATROL_SPAWNS)) {
            return;
        }
        int var12 = (int)Math.ceil(var0.getCurrentDifficultyAt(var9).getEffectiveDifficulty()) + 1;
        for (int var13 = 0; var13 < var12; ++var13) {
            var9.setY(var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var9).getY());
            if (var13 == 0) {
                if (!this.spawnPatrolMember(var0, var9, var2, true)) {
                    break;
                }
            } else {
                this.spawnPatrolMember(var0, var9, var2, false);
            }
            var9.setX(var9.getX() + var2.nextInt(5) - var2.nextInt(5));
            var9.setZ(var9.getZ() + var2.nextInt(5) - var2.nextInt(5));
        }
    }

    private boolean spawnPatrolMember(WorldServer var0, BlockPosition var1, RandomSource var2, boolean var3) {
        IBlockData var4 = var0.getBlockState(var1);
        if (!SpawnerCreature.isValidEmptySpawnBlock(var0, var1, var4, var4.getFluidState(), EntityTypes.PILLAGER)) {
            return false;
        }
        if (!EntityMonsterPatrolling.checkPatrollingMonsterSpawnRules(EntityTypes.PILLAGER, var0, EntitySpawnReason.PATROL, var1, var2)) {
            return false;
        }
        EntityMonsterPatrolling var5 = EntityTypes.PILLAGER.create(var0, EntitySpawnReason.PATROL);
        if (var5 != null) {
            if (var3) {
                var5.setPatrolLeader(true);
                var5.findPatrolTarget();
            }
            var5.setPos(var1.getX(), var1.getY(), var1.getZ());
            var5.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var1), EntitySpawnReason.PATROL, null);
            var0.addFreshEntityWithPassengers(var5);
            return true;
        }
        return false;
    }
}

