/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.FeatureCountTracker;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> CODEC = BuiltInRegistries.CHUNK_GENERATOR.byNameCodec().dispatchStable(ChunkGenerator::codec, Function.identity());
    protected final WorldChunkManager biomeSource;
    private final Supplier<List<FeatureSorter.b>> featuresPerStep;
    public final Function<Holder<BiomeBase>, BiomeSettingsGeneration> generationSettingsGetter;

    public ChunkGenerator(WorldChunkManager var02) {
        this(var02, var0 -> ((BiomeBase)var0.value()).getGenerationSettings());
    }

    public ChunkGenerator(WorldChunkManager var0, Function<Holder<BiomeBase>, BiomeSettingsGeneration> var1) {
        this.biomeSource = var0;
        this.generationSettingsGetter = var1;
        this.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(var0.possibleBiomes()), var1 -> ((BiomeSettingsGeneration)var1.apply((Holder<BiomeBase>)var1)).features(), true));
    }

    public void validate() {
        this.featuresPerStep.get();
    }

    protected abstract MapCodec<? extends ChunkGenerator> codec();

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> var0, RandomState var1, long var2) {
        return ChunkGeneratorStructureState.createForNormal(var1, var2, this.biomeSource, var0);
    }

    public Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> getTypeNameForDataFixer() {
        return BuiltInRegistries.CHUNK_GENERATOR.getResourceKey(this.codec());
    }

    public CompletableFuture<IChunkAccess> createBiomes(RandomState var0, Blender var1, StructureManager var2, IChunkAccess var3) {
        return CompletableFuture.supplyAsync(() -> {
            var3.fillBiomesFromNoise(this.biomeSource, var0.sampler());
            return var3;
        }, SystemUtils.backgroundExecutor().forName("init_biomes"));
    }

    public abstract void applyCarvers(RegionLimitedWorldAccess var1, long var2, RandomState var4, BiomeManager var5, StructureManager var6, IChunkAccess var7);

    @Nullable
    public Pair<BlockPosition, Holder<Structure>> findNearestMapStructure(WorldServer var02, HolderSet<Structure> var1, BlockPosition var2, int var3, boolean var4) {
        if (SharedConstants.DEBUG_DISABLE_FEATURES) {
            return null;
        }
        ChunkGeneratorStructureState var5 = var02.getChunkSource().getGeneratorState();
        Object2ObjectArrayMap var6 = new Object2ObjectArrayMap();
        for (Holder holder : var1) {
            for (StructurePlacement structurePlacement : var5.getPlacementsForStructure(holder)) {
                var6.computeIfAbsent(structurePlacement, var0 -> new ObjectArraySet()).add(holder);
            }
        }
        if (var6.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> var7 = null;
        double d2 = Double.MAX_VALUE;
        StructureManager structureManager = var02.structureManager();
        ArrayList var11 = new ArrayList(var6.size());
        for (Map.Entry var13 : var6.entrySet()) {
            StructurePlacement var14 = (StructurePlacement)var13.getKey();
            if (var14 instanceof ConcentricRingsStructurePlacement) {
                BlockPosition blockPosition;
                double var18;
                ConcentricRingsStructurePlacement var15 = (ConcentricRingsStructurePlacement)var14;
                Pair<BlockPosition, Holder<Structure>> var16 = this.getNearestGeneratedStructure((Set)var13.getValue(), var02, structureManager, var2, var4, var15);
                if (var16 == null || !((var18 = var2.distSqr(blockPosition = (BlockPosition)var16.getFirst())) < d2)) continue;
                d2 = var18;
                var7 = var16;
                continue;
            }
            if (!(var14 instanceof RandomSpreadStructurePlacement)) continue;
            var11.add(var13);
        }
        if (!var11.isEmpty()) {
            int var12 = SectionPosition.blockToSectionCoord(var2.getX());
            int var13 = SectionPosition.blockToSectionCoord(var2.getZ());
            for (int var14 = 0; var14 <= var3; ++var14) {
                boolean var15 = false;
                for (Map.Entry entry : var11) {
                    RandomSpreadStructurePlacement var18 = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPosition, Holder<Structure>> var19 = ChunkGenerator.getNearestGeneratedStructure((Set)entry.getValue(), var02, structureManager, var12, var13, var14, var4, var5.getLevelSeed(), var18);
                    if (var19 == null) continue;
                    var15 = true;
                    double var20 = var2.distSqr((BaseBlockPosition)var19.getFirst());
                    if (!(var20 < d2)) continue;
                    d2 = var20;
                    var7 = var19;
                }
                if (!var15) continue;
                return var7;
            }
        }
        return var7;
    }

    @Nullable
    private Pair<BlockPosition, Holder<Structure>> getNearestGeneratedStructure(Set<Holder<Structure>> var0, WorldServer var1, StructureManager var2, BlockPosition var3, boolean var4, ConcentricRingsStructurePlacement var5) {
        List<ChunkCoordIntPair> var6 = var1.getChunkSource().getGeneratorState().getRingPositionsFor(var5);
        if (var6 == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        Pair<BlockPosition, Holder<Structure>> var7 = null;
        double var8 = Double.MAX_VALUE;
        BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
        for (ChunkCoordIntPair var12 : var6) {
            Pair<BlockPosition, Holder<Structure>> var16;
            var10.set(SectionPosition.sectionToBlockCoord(var12.x, 8), 32, SectionPosition.sectionToBlockCoord(var12.z, 8));
            double var13 = var10.distSqr(var3);
            boolean var15 = var7 == null || var13 < var8;
            if (!var15 || (var16 = ChunkGenerator.getStructureGeneratingAt(var0, var1, var2, var4, var5, var12)) == null) continue;
            var7 = var16;
            var8 = var13;
        }
        return var7;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<Structure>> getNearestGeneratedStructure(Set<Holder<Structure>> var0, IWorldReader var1, StructureManager var2, int var3, int var4, int var5, boolean var6, long var7, RandomSpreadStructurePlacement var9) {
        int var10 = var9.spacing();
        for (int var11 = -var5; var11 <= var5; ++var11) {
            boolean var12 = var11 == -var5 || var11 == var5;
            for (int var13 = -var5; var13 <= var5; ++var13) {
                int var16;
                int var15;
                ChunkCoordIntPair var17;
                Pair<BlockPosition, Holder<Structure>> var18;
                boolean var14;
                boolean bl = var14 = var13 == -var5 || var13 == var5;
                if (!var12 && !var14 || (var18 = ChunkGenerator.getStructureGeneratingAt(var0, var1, var2, var6, var9, var17 = var9.getPotentialStructureChunk(var7, var15 = var3 + var10 * var11, var16 = var4 + var10 * var13))) == null) continue;
                return var18;
            }
        }
        return null;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<Structure>> getStructureGeneratingAt(Set<Holder<Structure>> var0, IWorldReader var1, StructureManager var2, boolean var3, StructurePlacement var4, ChunkCoordIntPair var5) {
        for (Holder<Structure> var7 : var0) {
            StructureCheckResult var8 = var2.checkStructurePresence(var5, var7.value(), var4, var3);
            if (var8 == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!var3 && var8 == StructureCheckResult.START_PRESENT) {
                return Pair.of((Object)var4.getLocatePos(var5), var7);
            }
            IChunkAccess var9 = var1.getChunk(var5.x, var5.z, ChunkStatus.STRUCTURE_STARTS);
            StructureStart var10 = var2.getStartForStructure(SectionPosition.bottomOf(var9), var7.value(), var9);
            if (var10 == null || !var10.isValid() || var3 && !ChunkGenerator.tryAddReference(var2, var10)) continue;
            return Pair.of((Object)var4.getLocatePos(var10.getChunkPos()), var7);
        }
        return null;
    }

    private static boolean tryAddReference(StructureManager var0, StructureStart var1) {
        if (var1.canBeReferenced()) {
            var0.addReference(var1);
            return true;
        }
        return false;
    }

    public void applyBiomeDecoration(GeneratorAccessSeed var02, IChunkAccess var1, StructureManager var2) {
        ChunkCoordIntPair var3 = var1.getPos();
        if (SharedConstants.debugVoidTerrain(var3)) {
            return;
        }
        SectionPosition var4 = SectionPosition.of(var3, var02.getMinSectionY());
        BlockPosition var52 = var4.origin();
        HolderLookup.b var6 = var02.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        Map<Integer, List<Structure>> var7 = var6.stream().collect(Collectors.groupingBy(var0 -> var0.step().ordinal()));
        List<FeatureSorter.b> var8 = this.featuresPerStep.get();
        SeededRandom var9 = new SeededRandom(new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
        long var10 = var9.setDecorationSeed(var02.getSeed(), var52.getX(), var52.getZ());
        ObjectArraySet var12 = new ObjectArraySet();
        ChunkCoordIntPair.rangeClosed(var4.chunk(), 1).forEach(arg_0 -> ChunkGenerator.a(var02, (Set)var12, arg_0));
        var12.retainAll(this.biomeSource.possibleBiomes());
        int var13 = var8.size();
        try {
            HolderLookup.b var14 = var02.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE);
            int var15 = Math.max(WorldGenStage.Decoration.values().length, var13);
            for (int var16 = 0; var16 < var15; ++var16) {
                List<HolderSet<PlacedFeature>> var21;
                Object var202;
                IntArraySet var18;
                int var17 = 0;
                if (var2.shouldGenerateStructures()) {
                    var18 = var7.getOrDefault(var16, Collections.emptyList());
                    for (Object var202 : var18) {
                        var9.setFeatureSeed(var10, var17, var16);
                        var21 = () -> ChunkGenerator.a((IRegistry)var6, (Structure)var202);
                        try {
                            var02.setCurrentlyGenerating((Supplier<String>)((Object)var21));
                            var2.startsForStructure(var4, (Structure)var202).forEach(var5 -> var5.placeInChunk(var02, var2, this, var9, ChunkGenerator.getWritableArea(var1), var3));
                        }
                        catch (Exception var22) {
                            CrashReport var23 = CrashReport.forThrowable(var22, "Feature placement");
                            var23.addCategory("Feature").setDetail("Description", ((Supplier)((Object)var21))::get);
                            throw new ReportedException(var23);
                        }
                        ++var17;
                    }
                }
                if (var16 >= var13) continue;
                var18 = new IntArraySet();
                for (Object var202 : var12) {
                    var21 = this.generationSettingsGetter.apply((Holder<BiomeBase>)var202).features();
                    if (var16 >= var21.size()) continue;
                    HolderSet var22 = (HolderSet)var21.get(var16);
                    FeatureSorter.b var23 = var8.get(var16);
                    var22.stream().map(Holder::value).forEach(arg_0 -> ChunkGenerator.a((IntSet)var18, var23, arg_0));
                }
                int var19 = var18.size();
                var202 = var18.toIntArray();
                Arrays.sort((int[])var202);
                var21 = var8.get(var16);
                for (int var22 = 0; var22 < var19; ++var22) {
                    Object var23 = var202[var22];
                    PlacedFeature var24 = ((FeatureSorter.b)((Object)var21)).features().get((int)var23);
                    Supplier<String> var25 = () -> ChunkGenerator.a((IRegistry)var14, var24);
                    var9.setFeatureSeed(var10, (int)var23, var16);
                    try {
                        var02.setCurrentlyGenerating(var25);
                        var24.placeWithBiomeCheck(var02, this, var9, var52);
                        continue;
                    }
                    catch (Exception var26) {
                        CrashReport var27 = CrashReport.forThrowable(var26, "Feature placement");
                        var27.addCategory("Feature").setDetail("Description", var25::get);
                        throw new ReportedException(var27);
                    }
                }
            }
            var02.setCurrentlyGenerating(null);
            if (SharedConstants.DEBUG_FEATURE_COUNT) {
                FeatureCountTracker.chunkDecorated(var02.getLevel());
            }
        }
        catch (Exception var14) {
            CrashReport var15 = CrashReport.forThrowable(var14, "Biome decoration");
            var15.addCategory("Generation").setDetail("CenterX", var3.x).setDetail("CenterZ", var3.z).setDetail("Decoration Seed", var10);
            throw new ReportedException(var15);
        }
    }

    private static StructureBoundingBox getWritableArea(IChunkAccess var0) {
        ChunkCoordIntPair var1 = var0.getPos();
        int var2 = var1.getMinBlockX();
        int var3 = var1.getMinBlockZ();
        LevelHeightAccessor var4 = var0.getHeightAccessorForGeneration();
        int var5 = var4.getMinY() + 1;
        int var6 = var4.getMaxY();
        return new StructureBoundingBox(var2, var5, var3, var2 + 15, var6, var3 + 15);
    }

    public abstract void buildSurface(RegionLimitedWorldAccess var1, StructureManager var2, RandomState var3, IChunkAccess var4);

    public abstract void spawnOriginalMobs(RegionLimitedWorldAccess var1);

    public int getSpawnHeight(LevelHeightAccessor var0) {
        return 64;
    }

    public WorldChunkManager getBiomeSource() {
        return this.biomeSource;
    }

    public abstract int getGenDepth();

    public WeightedList<BiomeSettingsMobs.c> getMobsAt(Holder<BiomeBase> var0, StructureManager var12, EnumCreatureType var22, BlockPosition var3) {
        Map<Structure, LongSet> var4 = var12.getAllStructuresAt(var3);
        for (Map.Entry<Structure, LongSet> var6 : var4.entrySet()) {
            Structure var7 = var6.getKey();
            StructureSpawnOverride var8 = var7.spawnOverrides().get(var22);
            if (var8 == null) continue;
            MutableBoolean var9 = new MutableBoolean(false);
            Predicate<StructureStart> var10 = var8.boundingBox() == StructureSpawnOverride.a.PIECE ? var2 -> var12.structureHasPieceAt(var3, (StructureStart)var2) : var1 -> var1.getBoundingBox().isInside(var3);
            var12.fillStartsForStructure(var7, var6.getValue(), var2 -> {
                if (var9.isFalse() && var10.test((StructureStart)var2)) {
                    var9.setTrue();
                }
            });
            if (!var9.isTrue()) continue;
            return var8.spawns();
        }
        return var0.value().getMobSettings().getMobs(var22);
    }

    public void createStructures(IRegistryCustom var0, ChunkGeneratorStructureState var1, StructureManager var2, IChunkAccess var3, StructureTemplateManager var4, ResourceKey<World> var5) {
        if (SharedConstants.DEBUG_DISABLE_STRUCTURES) {
            return;
        }
        ChunkCoordIntPair var6 = var3.getPos();
        SectionPosition var7 = SectionPosition.bottomOf(var3);
        RandomState var8 = var1.randomState();
        var1.possibleStructureSets().forEach(var9 -> {
            StructurePlacement var10 = ((StructureSet)var9.value()).placement();
            List<StructureSet.a> var11 = ((StructureSet)var9.value()).structures();
            for (StructureSet.a a2 : var11) {
                StructureStart var14 = var2.getStartForStructure(var7, a2.structure().value(), var3);
                if (var14 == null || !var14.isValid()) continue;
                return;
            }
            if (!var10.isStructureChunk(var1, var4.x, var4.z)) {
                return;
            }
            if (var11.size() == 1) {
                this.tryGenerateStructure(var11.get(0), var2, var0, var8, var4, var1.getLevelSeed(), var3, var6, var7, var5);
                return;
            }
            ArrayList<StructureSet.a> var12 = new ArrayList<StructureSet.a>(var11.size());
            var12.addAll(var11);
            SeededRandom seededRandom = new SeededRandom(new LegacyRandomSource(0L));
            seededRandom.setLargeFeatureSeed(var1.getLevelSeed(), var4.x, var4.z);
            int var14 = 0;
            for (StructureSet.a var16 : var12) {
                var14 += var16.weight();
            }
            while (!var12.isEmpty()) {
                StructureSet.a var18;
                int var15 = seededRandom.nextInt(var14);
                int var16 = 0;
                Iterator iterator = var12.iterator();
                while (iterator.hasNext() && (var15 -= (var18 = (StructureSet.a)iterator.next()).weight()) >= 0) {
                    ++var16;
                }
                StructureSet.a var17 = (StructureSet.a)var12.get(var16);
                if (this.tryGenerateStructure(var17, var2, var0, var8, var4, var1.getLevelSeed(), var3, var6, var7, var5)) {
                    return;
                }
                var12.remove(var16);
                var14 -= var17.weight();
            }
        });
    }

    private boolean tryGenerateStructure(StructureSet.a var0, StructureManager var1, IRegistryCustom var2, RandomState var3, StructureTemplateManager var4, long var5, IChunkAccess var7, ChunkCoordIntPair var8, SectionPosition var9, ResourceKey<World> var10) {
        Structure var11 = var0.structure().value();
        int var12 = ChunkGenerator.fetchReferences(var1, var7, var9, var11);
        HolderSet<BiomeBase> var13 = var11.biomes();
        Predicate<Holder<BiomeBase>> var14 = var13::contains;
        StructureStart var15 = var11.generate(var0.structure(), var10, var2, this, this.biomeSource, var3, var4, var5, var8, var12, var7, var14);
        if (var15.isValid()) {
            var1.setStartForStructure(var9, var11, var15, var7);
            return true;
        }
        return false;
    }

    private static int fetchReferences(StructureManager var0, IChunkAccess var1, SectionPosition var2, Structure var3) {
        StructureStart var4 = var0.getStartForStructure(var2, var3, var1);
        return var4 != null ? var4.getReferences() : 0;
    }

    public void createReferences(GeneratorAccessSeed var0, StructureManager var1, IChunkAccess var2) {
        int var3 = 8;
        ChunkCoordIntPair var4 = var2.getPos();
        int var5 = var4.x;
        int var6 = var4.z;
        int var7 = var4.getMinBlockX();
        int var8 = var4.getMinBlockZ();
        SectionPosition var9 = SectionPosition.bottomOf(var2);
        for (int var10 = var5 - 8; var10 <= var5 + 8; ++var10) {
            for (int var11 = var6 - 8; var11 <= var6 + 8; ++var11) {
                long var12 = ChunkCoordIntPair.asLong(var10, var11);
                for (StructureStart var15 : var0.getChunk(var10, var11).getAllStarts().values()) {
                    try {
                        if (!var15.isValid() || !var15.getBoundingBox().intersects(var7, var8, var7 + 15, var8 + 15)) continue;
                        var1.addReferenceForStructure(var9, var15.getStructure(), var12, var2);
                    }
                    catch (Exception var16) {
                        CrashReport var17 = CrashReport.forThrowable(var16, "Generating structure reference");
                        CrashReportSystemDetails var18 = var17.addCategory("Structure");
                        Optional<IRegistry<Structure>> var19 = var0.registryAccess().lookup(Registries.STRUCTURE);
                        var18.setDetail("Id", () -> var19.map(var1 -> var1.getKey(var15.getStructure()).toString()).orElse("UNKNOWN"));
                        var18.setDetail("Name", () -> BuiltInRegistries.STRUCTURE_TYPE.getKey(var15.getStructure().type()).toString());
                        var18.setDetail("Class", () -> var15.getStructure().getClass().getCanonicalName());
                        throw new ReportedException(var17);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<IChunkAccess> fillFromNoise(Blender var1, RandomState var2, StructureManager var3, IChunkAccess var4);

    public abstract int getSeaLevel();

    public abstract int getMinY();

    public abstract int getBaseHeight(int var1, int var2, HeightMap.Type var3, LevelHeightAccessor var4, RandomState var5);

    public abstract BlockColumn getBaseColumn(int var1, int var2, LevelHeightAccessor var3, RandomState var4);

    public int getFirstFreeHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3, RandomState var4) {
        return this.getBaseHeight(var0, var1, var2, var3, var4);
    }

    public int getFirstOccupiedHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3, RandomState var4) {
        return this.getBaseHeight(var0, var1, var2, var3, var4) - 1;
    }

    public abstract void addDebugScreenInfo(List<String> var1, RandomState var2, BlockPosition var3);

    @Deprecated
    public BiomeSettingsGeneration getBiomeGenerationSettings(Holder<BiomeBase> var0) {
        return this.generationSettingsGetter.apply(var0);
    }

    private static /* synthetic */ String a(IRegistry var0, PlacedFeature var1) {
        return var0.getResourceKey(var1).map(Object::toString).orElseGet(var1::toString);
    }

    private static /* synthetic */ void a(IntSet var0, FeatureSorter.b var1, PlacedFeature var2) {
        var0.add(var1.indexMapping().applyAsInt(var2));
    }

    private static /* synthetic */ String a(IRegistry var0, Structure var1) {
        return var0.getResourceKey(var1).map(Object::toString).orElseGet(var1::toString);
    }

    private static /* synthetic */ void a(GeneratorAccessSeed var0, Set var1, ChunkCoordIntPair var2) {
        IChunkAccess var3 = var0.getChunk(var2.x, var2.z);
        for (ChunkSection var7 : var3.getSections()) {
            var7.getBiomes().getAll(var1::add);
        }
    }
}

