/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import org.apache.commons.lang3.mutable.MutableInt;

public class TileEntityBell
extends TileEntity {
    private static final int DURATION = 50;
    private static final int GLOW_DURATION = 60;
    private static final int MIN_TICKS_BETWEEN_SEARCHES = 60;
    private static final int MAX_RESONATION_TICKS = 40;
    private static final int TICKS_BEFORE_RESONATION = 5;
    private static final int SEARCH_RADIUS = 48;
    private static final int HEAR_BELL_RADIUS = 32;
    private static final int HIGHLIGHT_RAIDERS_RADIUS = 48;
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public EnumDirection clickDirection;
    private List<EntityLiving> nearbyEntities;
    public boolean resonating;
    public int resonationTicks;

    public TileEntityBell(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BELL, var0, var1);
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (var0 == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = EnumDirection.from3DDataValue(var1);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    private static void tick(World var0, BlockPosition var1, IBlockData var2, TileEntityBell var3, a var4) {
        if (var3.shaking) {
            ++var3.ticks;
        }
        if (var3.ticks >= 50) {
            var3.shaking = false;
            var3.ticks = 0;
        }
        if (var3.ticks >= 5 && var3.resonationTicks == 0 && TileEntityBell.areRaidersNearby(var1, var3.nearbyEntities)) {
            var3.resonating = true;
            var0.playSound(null, var1, SoundEffects.BELL_RESONATE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (var3.resonating) {
            if (var3.resonationTicks < 40) {
                ++var3.resonationTicks;
            } else {
                var4.run(var0, var1, var3.nearbyEntities);
                var3.resonating = false;
            }
        }
    }

    public static void clientTick(World var0, BlockPosition var1, IBlockData var2, TileEntityBell var3) {
        TileEntityBell.tick(var0, var1, var2, var3, TileEntityBell::showBellParticles);
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, TileEntityBell var3) {
        TileEntityBell.tick(var0, var1, var2, var3, TileEntityBell::makeRaidersGlow);
    }

    public void onHit(EnumDirection var0) {
        BlockPosition var1 = this.getBlockPos();
        this.clickDirection = var0;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        this.level.blockEvent(var1, this.getBlockState().getBlock(), 1, var0.get3DDataValue());
    }

    private void updateEntities() {
        BlockPosition var0 = this.getBlockPos();
        if (this.level.getGameTime() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
            this.lastRingTimestamp = this.level.getGameTime();
            AxisAlignedBB var1 = new AxisAlignedBB(var0).inflate(48.0);
            this.nearbyEntities = this.level.getEntitiesOfClass(EntityLiving.class, var1);
        }
        if (!this.level.isClientSide()) {
            for (EntityLiving var2 : this.nearbyEntities) {
                if (!var2.isAlive() || var2.isRemoved() || !var0.closerToCenterThan(var2.position(), 32.0)) continue;
                var2.getBrain().setMemory(MemoryModuleType.HEARD_BELL_TIME, this.level.getGameTime());
            }
        }
    }

    private static boolean areRaidersNearby(BlockPosition var0, List<EntityLiving> var1) {
        for (EntityLiving var3 : var1) {
            if (!var3.isAlive() || var3.isRemoved() || !var0.closerToCenterThan(var3.position(), 32.0) || !var3.getType().is(TagsEntity.RAIDERS)) continue;
            return true;
        }
        return false;
    }

    private static void makeRaidersGlow(World var0, BlockPosition var12, List<EntityLiving> var2) {
        var2.stream().filter(var1 -> TileEntityBell.isRaiderWithinRange(var12, var1)).forEach(TileEntityBell::glow);
    }

    private static void showBellParticles(World var0, BlockPosition var12, List<EntityLiving> var2) {
        MutableInt var3 = new MutableInt(16700985);
        int var42 = (int)var2.stream().filter(var1 -> var12.closerToCenterThan(var1.position(), 48.0)).count();
        var2.stream().filter(var1 -> TileEntityBell.isRaiderWithinRange(var12, var1)).forEach(var4 -> {
            float var5 = 1.0f;
            double var6 = Math.sqrt((var4.getX() - (double)var12.getX()) * (var4.getX() - (double)var12.getX()) + (var4.getZ() - (double)var12.getZ()) * (var4.getZ() - (double)var12.getZ()));
            double var8 = (double)((float)var12.getX() + 0.5f) + 1.0 / var6 * (var4.getX() - (double)var12.getX());
            double var10 = (double)((float)var12.getZ() + 0.5f) + 1.0 / var6 * (var4.getZ() - (double)var12.getZ());
            int var12 = MathHelper.clamp((var42 - 21) / -2, 3, 15);
            for (int var13 = 0; var13 < var12; ++var13) {
                int var14 = var3.addAndGet(5);
                var0.addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, var14), var8, (float)var12.getY() + 0.5f, var10, 0.0, 0.0, 0.0);
            }
        });
    }

    private static boolean isRaiderWithinRange(BlockPosition var0, EntityLiving var1) {
        return var1.isAlive() && !var1.isRemoved() && var0.closerToCenterThan(var1.position(), 48.0) && var1.getType().is(TagsEntity.RAIDERS);
    }

    private static void glow(EntityLiving var0) {
        var0.addEffect(new MobEffect(MobEffects.GLOWING, 60));
    }

    @FunctionalInterface
    static interface a {
        public void run(World var1, BlockPosition var2, List<EntityLiving> var3);
    }
}

